package com.finconsgroup.itserr.marketplace.favourite.user.bs.messaging;

import com.fasterxml.jackson.core.type.TypeReference;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.config.FavouriteUserBsProperties;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.config.MessagingNewsBsProperties;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.enums.ItemContext;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.messaging.dto.NewsCreatedMessagingAdditionalDataDto;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.service.FavouriteUserItemService;
import com.finconsgroup.itserr.messaging.consumer.CloudEventConsumer;
import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;
import io.cloudevents.CloudEvent;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

@Component("newsEventConsumer")
@Slf4j
public class NewsEventConsumer extends CloudEventConsumer {

    private final FavouriteUserItemService favouriteUserItemService;

    /**
     * Constructs the NewsEventConsumer
     *
     * @param favouriteUserBsConfigurationProperties the application configuration properties
     * @param favouriteUserItemService               favourite user item service
     */
    public NewsEventConsumer(FavouriteUserBsProperties favouriteUserBsConfigurationProperties,
                             FavouriteUserItemService favouriteUserItemService) {
        MessagingNewsBsProperties messagingNewsBsProperties = favouriteUserBsConfigurationProperties.messaging().getNewsBs();
        addHandler(messagingNewsBsProperties.getResourceCreatedEventType(), new TypeReference<>() {
                },
                this::handleResourceCreated);

        this.favouriteUserItemService = favouriteUserItemService;
    }

    private void handleResourceCreated(MessagingEventDto<NewsCreatedMessagingAdditionalDataDto> eventPayload,
                                       CloudEvent cloudEvent) {
        favouriteUserItemService.publishResourceCreatedByFolloweeEvent(ItemContext.NEWS_ID,
                eventPayload.getUser().getId().toString(), eventPayload);
    }

}