package com.finconsgroup.itserr.marketplace.favourite.user.bs.bean;

import com.finconsgroup.itserr.marketplace.core.web.dto.PageRequestDto;
import com.finconsgroup.itserr.marketplace.favourite.user.bs.enums.ItemContext;
import lombok.Builder;
import lombok.Data;

import java.util.List;

/**
 * Request to get details for the items including any filters applied and pagination information.
 */
@Builder
@Data
public class DetailRequest {
    /**
     * The item context
     */
    private final ItemContext itemContext;

    /**
     * The ids of items to fetch detail for
     */
    private final List<String> itemIds;
    private final List<Filter> filters;
    private final PageRequestDto pageRequestDto;

    @Builder
    @Data
    public static class Filter {
        private final String key;
        private final String value;
    }
}
