package com.finconsgroup.itserr.marketplace.favouritesearch.dm.mapper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2BusinessException;
import com.finconsgroup.itserr.marketplace.favouritesearch.dm.dto.InputCreateFavouriteSearchDto;
import com.finconsgroup.itserr.marketplace.favouritesearch.dm.dto.OutputFavouriteSearchDto;
import com.finconsgroup.itserr.marketplace.favouritesearch.dm.dto.SearchFilterFavouriteSearchDto;
import com.finconsgroup.itserr.marketplace.favouritesearch.dm.entity.FavouriteSearchEntity;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Named;

import java.util.List;
import java.util.UUID;

@Mapper(config = MapperConfiguration.class)
public interface FavouriteSearchMapper {
    String SEARCH_FILTERS_SERIALIZE = "serializeSearchFilters";
    String SEARCH_FILTERS_DESERIALIZE = "deserializeSearchFilters";

    @Mapping(target = "id", ignore = true)
    @Mapping(target = "creationTime", ignore = true)
    @Mapping(target = "updateTime", ignore = true)
    @Mapping(target = "version", ignore = true)
    @Mapping(target = "searchFilters", source = "model.searchFilters", qualifiedByName = SEARCH_FILTERS_SERIALIZE)
    FavouriteSearchEntity toEntity(InputCreateFavouriteSearchDto model, UUID userId);

    @Mapping(target = "searchFilters", source = "searchFilters", qualifiedByName = SEARCH_FILTERS_DESERIALIZE)
    OutputFavouriteSearchDto toDto(FavouriteSearchEntity entity);

    @Named(SEARCH_FILTERS_SERIALIZE)
    static String serializeSearchFilters(List<SearchFilterFavouriteSearchDto> searchFilters) {
        if (searchFilters == null)
            return null;

        try {
            ObjectMapper objectMapper = new ObjectMapper();
            return objectMapper.writeValueAsString(searchFilters);
        } catch (JsonProcessingException e) {
            throw new WP2BusinessException("Failed to serialize searchFilters", e);
        }
    }

    @Named(SEARCH_FILTERS_DESERIALIZE)
    static List<SearchFilterFavouriteSearchDto> deserializeSearchFilters(String searchFilters) {
        if (searchFilters == null)
            return null;

        try {
            ObjectMapper objectMapper = new ObjectMapper();
            return objectMapper.readValue(
                    searchFilters,
                    new TypeReference<>() {}
            );
        } catch (JsonProcessingException e) {
            throw new WP2BusinessException("Failed to deserialize searchFilters", e);
        }
    }
}
