package com.finconsgroup.itserr.marketplace.favouritesearch.dm.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.finconsgroup.itserr.marketplace.favouritesearch.dm.enums.SearchContext;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.UUID;

/**
 * Output DTO representing a favouriteSearch.
 */
@Schema(name = "OutputFavouriteSearch", description = "DTO representing a favouriteSearch in response")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class OutputFavouriteSearchDto {

    @Schema(description = "The ID of the resource", example = "a9e17e76-8e8f-4a3b-a7a0-29f9b7c6e275")
    private UUID id;

    @Schema(description = "The name of the favourite search", example = "My favourite search")
    private String name;

    @Schema(description = "The ID of the associated user", example = "de7b8f89-f1a4-4a1f-96e0-32e6d7b39c3f")
    private UUID userId;

    @Schema(description = "The context of the favourite search", example = "items")
    private SearchContext context;

    @Schema(description = "The text used to perform the search", example = "Godfath")
    private String searchText;

    @Schema(description = "The raw filters of the search", example = "[{key: type, value: dataset}]")
    private List<SearchFilterFavouriteSearchDto> searchFilters;

    @Schema(description = "The creation time of the table record", example = "2025-04-06T10:15:30+01:00")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ssXXX")
    private ZonedDateTime creationTime;

    @Schema(description = "The last update time of the table record", example = "2025-04-06T10:15:30+01:00")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ssXXX")
    private ZonedDateTime updateTime;

}
