/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.favouritesearch.bs.api;

import com.finconsgroup.itserr.marketplace.favouritesearch.bs.dto.InputCreateFavouriteSearchDto;
import com.finconsgroup.itserr.marketplace.favouritesearch.bs.dto.OutputFavouriteSearchDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.UUID;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Tag(name="FavouriteSearch", description="The FavouriteSearch API: it provides endpoints for retrieving, creating, and deleting FavouriteSearch.")
@SecurityRequirement(name="BearerAuth")
public interface FavouriteSearchApi {
    @Operation(summary="create a favouriteSearch for the authenticated user", responses={@ApiResponse(responseCode="201", description="Created")})
    @PostMapping(value={"/favourite-searches"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public OutputFavouriteSearchDto create(@Valid @RequestBody InputCreateFavouriteSearchDto var1);

    @Operation(summary="delete favouriteSearch by id for the authenticated user", responses={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="404", description="Not Found")})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @DeleteMapping(value={"/favourite-searches/{favouriteSearchId}"}, produces={"application/json"})
    public void deleteById(@PathVariable(value="favouriteSearchId") UUID var1);
}

