package com.finconsgroup.itserr.marketplace.favouritesearch.bs.enums;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Enumeration for all supported context values for favourite search items.
 */
public enum SearchContext {
    ITEMS("items"), PROJECTS("projects");

    private final String id;

    SearchContext(String id) {
        this.id = id;
    }

    /**
     * Returns the id of the search context.
     *
     * @return string id
     */
    @JsonValue
    public String getId() {
        return id;
    }

    @Override
    public String toString() {
        return id;
    }

    /**
     * It maps the name to a {@link SearchContext} object
     *
     * @param id the id to map to item context
     * @return {@link SearchContext} instance if found
     * @throws IllegalArgumentException if no matching category instance found
     */
    public static SearchContext ofId(String id) {
        for (SearchContext searchContext : SearchContext.values()) {
            if (searchContext.id.equalsIgnoreCase(id)) {
                return searchContext;
            }
        }

        throw new IllegalArgumentException("Unsupported item context : " + id);
    }


}
