package com.finconsgroup.itserr.marketplace.favouritesearch.bs.controller;

import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;

import com.finconsgroup.itserr.marketplace.favouritesearch.bs.api.FavouriteSearchApi;
import com.finconsgroup.itserr.marketplace.favouritesearch.bs.dto.InputCreateFavouriteSearchDto;
import com.finconsgroup.itserr.marketplace.favouritesearch.bs.dto.OutputFavouriteSearchDto;
import com.finconsgroup.itserr.marketplace.favouritesearch.bs.service.FavouriteSearchService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import org.springframework.web.bind.annotation.RestController;

import java.util.UUID;

/**
 * REST controller class for handling favourite searches related API requests.
 *
 * <p>Implements the {@link FavouriteSearchApi} interface.</p>
 */
@Slf4j
@RequiredArgsConstructor
@RestController
public class FavouriteSearchController implements FavouriteSearchApi {

    private final FavouriteSearchService favouriteSearchService;

    @Override
    public OutputFavouriteSearchDto create(final InputCreateFavouriteSearchDto inputCreateFavouriteSearchDto) {

        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        return this.favouriteSearchService.create(userId, inputCreateFavouriteSearchDto);
    }

    @Override
    public void deleteById(UUID favouriteSearchId) {
        this.favouriteSearchService.deleteById(favouriteSearchId);
    }
}
