/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.echo.dm.websocket;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

@Component
public class NotificationsWebSocketHandler
extends TextWebSocketHandler {
    private final Set<WebSocketSession> sessions = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterConnectionEstablished(@NonNull WebSocketSession session) {
        Set set = this.sessions;
        synchronized (set) {
            this.sessions.add(session);
        }
        try {
            this.send(session, "Connected as user: " + String.valueOf(session.getAttributes().get("username")));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void handleTextMessage(@NonNull WebSocketSession session, @NonNull TextMessage message) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterConnectionClosed(@NonNull WebSocketSession session, @NonNull CloseStatus status) {
        Set set = this.sessions;
        synchronized (set) {
            this.sessions.remove(session);
        }
    }

    public void send(String message) {
        this.send((String)null, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(String username, String message) {
        List<WebSocketSession> targetSessions;
        Set set = this.sessions;
        synchronized (set) {
            targetSessions = this.sessions.stream().filter(s -> username == null || username.equals(s.getAttributes().get("username"))).toList();
        }
        for (WebSocketSession session : targetSessions) {
            try {
                this.send(session, message);
            }
            catch (Exception exception) {}
        }
    }

    private void send(WebSocketSession session, String message) throws IOException {
        session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)message));
    }
}

