package com.finconsgroup.itserr.marketplace.echo.dm.service;

import java.util.Map;

/**
 * Service for handling business logic related to Orders.
 */
public interface OrderService {

    /**
     * Find all users.
     *
     * @return a string response
     */
    String findAllUsers(Map<String, String> headers);

    /**
     * Delete all users.
     *
     * @return a string response
     */
    String deleteAllUsers(Map<String, String> headers);

    /**
     * Find user by user id.
     *
     * @return a string response
     */
    String findUserByUserId(String userId, Map<String, String> headers);

    /**
     * Delete user by user id.
     *
     * @return a string response
     */
    String deleteUserByUserId(String userId, Map<String, String> headers);

    /**
     * Find all orders by user id.
     *
     * @return a string response
     */
    String findAllOrdersByUserId(String userId, Map<String, String> headers);

    /**
     * Delete all orders by user id.
     *
     * @return a string response
     */
    String deleteAllOrdersByUserId(String userId, Map<String, String> headers);

    /**
     * Find order by user id and order id.
     *
     * @return a string response
     */
    String findOrderByUserIdAndOrderId(String userId, String orderId, Map<String, String> headers);

    /**
     * Delete order by user id and order id.
     *
     * @return a string response
     */
    String deleteOrderByUserIdAndOrderId(String userId, String orderId, Map<String, String> headers);

}
