package com.finconsgroup.itserr.marketplace.echo.dm.controller;

import com.finconsgroup.itserr.marketplace.echo.dm.api.OrderApi;
import com.finconsgroup.itserr.marketplace.echo.dm.service.OrderService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

/**
 * Spring Boot REST Controller implementation for the {@link OrderApi} endpoints.
 */
@RestController
@RequiredArgsConstructor
@Slf4j
public class OrderController implements OrderApi {

    private final OrderService orderService;

    @Override
    public String findAllUsers(Map<String, String> headers) {
        return orderService.findAllUsers(headers);
    }

    @Override
    public String deleteAllUsers(Map<String, String> headers) {
        return orderService.deleteAllUsers(headers);
    }

    @Override
    public String findUserByUserId(String userId, Map<String, String> headers) {
        return orderService.findUserByUserId(userId, headers);
    }

    @Override
    public String deleteUserByUserId(String userId, Map<String, String> headers) {
        return orderService.deleteUserByUserId(userId, headers);
    }

    @Override
    public String findAllOrdersByUserId(String userId, Map<String, String> headers) {
        return orderService.findAllOrdersByUserId(userId, headers);
    }

    @Override
    public String deleteAllOrdersByUserId(String userId, Map<String, String> headers) {
        return orderService.deleteAllOrdersByUserId(userId, headers);
    }

    @Override
    public String findOrderByUserIdAndOrderId(String userId, String orderId, Map<String, String> headers) {
        return orderService.findOrderByUserIdAndOrderId(userId, orderId, headers);
    }

    @Override
    public String deleteOrderByUserIdAndOrderId(String userId, String orderId, Map<String, String> headers) {
        return orderService.deleteOrderByUserIdAndOrderId(userId, orderId, headers);
    }

}
