/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.discussion.dm.mapper;

import com.finconsgroup.itserr.marketplace.discussion.dm.dto.DiscussionCountByReactionDto;
import com.finconsgroup.itserr.marketplace.discussion.dm.dto.DiscussionDTO;
import com.finconsgroup.itserr.marketplace.discussion.dm.dto.DiscussionReactionDTO;
import com.finconsgroup.itserr.marketplace.discussion.dm.dto.ThreadCountByReactionDto;
import com.finconsgroup.itserr.marketplace.discussion.dm.dto.ThreadDTO;
import com.finconsgroup.itserr.marketplace.discussion.dm.dto.ThreadReactionDTO;
import com.finconsgroup.itserr.marketplace.discussion.dm.entity.Discussion;
import com.finconsgroup.itserr.marketplace.discussion.dm.entity.DiscussionReaction;
import com.finconsgroup.itserr.marketplace.discussion.dm.entity.Thread;
import com.finconsgroup.itserr.marketplace.discussion.dm.entity.ThreadReaction;
import com.finconsgroup.itserr.marketplace.discussion.dm.enums.ReactionType;
import com.finconsgroup.itserr.marketplace.discussion.dm.repository.DiscussionReactionRepository;
import com.finconsgroup.itserr.marketplace.discussion.dm.repository.DiscussionRepository;
import com.finconsgroup.itserr.marketplace.discussion.dm.repository.ThreadReactionRepository;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.mapstruct.AfterMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.mapstruct.Named;
import org.springframework.beans.factory.annotation.Autowired;

@Mapper(componentModel="spring")
public abstract class DiscussionMapper {
    protected DiscussionReactionRepository discussionReactionRepository;
    protected ThreadReactionRepository threadReactionRepository;
    protected DiscussionRepository discussionRepository;

    @Autowired
    public void setDiscussionRepository(DiscussionRepository discussionRepository) {
        this.discussionRepository = discussionRepository;
    }

    @Autowired
    public void setDiscussionReactionRepository(DiscussionReactionRepository discussionReactionRepository) {
        this.discussionReactionRepository = discussionReactionRepository;
    }

    @Autowired
    public void setThreadReactionRepository(ThreadReactionRepository threadReactionRepository) {
        this.threadReactionRepository = threadReactionRepository;
    }

    @Mappings(value={@Mapping(target="threads", qualifiedByName={"topLevelThreads"}), @Mapping(target="reactionCounts", ignore=true), @Mapping(target="threadsCount", ignore=true)})
    public abstract DiscussionDTO toDTO(Discussion var1);

    @Mappings(value={@Mapping(target="threads", ignore=true), @Mapping(target="reactionCounts", ignore=true), @Mapping(target="threadsCount", ignore=true)})
    public abstract DiscussionDTO toDTOWithoutThreads(Discussion var1);

    @Mappings(value={@Mapping(target="threads", ignore=true), @Mapping(target="reactions", ignore=true)})
    public abstract Discussion toEntity(DiscussionDTO var1);

    @AfterMapping
    protected void afterDiscussionToDTO(Discussion discussion, @MappingTarget DiscussionDTO dto) {
        if (discussion == null || dto == null) {
            return;
        }
        dto.setReactionCounts(this.calculateDiscussionReactionCounts(discussion));
        dto.setThreadsCount(Long.valueOf(this.discussionRepository.countAllThreadsByDiscussionId(discussion.getId())));
    }

    @Mappings(value={@Mapping(target="parentId", source="parent.id"), @Mapping(target="reactionCounts", ignore=true)})
    public abstract ThreadDTO mapThreadToDTO(Thread var1);

    @AfterMapping
    protected void afterThreadToDTO(Thread thread, @MappingTarget ThreadDTO dto) {
        if (thread == null || dto == null) {
            return;
        }
        dto.setReactionCounts(this.calculateThreadReactionCounts(thread));
    }

    public abstract ThreadReactionDTO mapThreadReactionToDTO(ThreadReaction var1);

    public abstract DiscussionReactionDTO mapDiscussionReactionToDTO(DiscussionReaction var1);

    @Named(value="topLevelThreads")
    protected List<ThreadDTO> mapThreadsToDTO(List<Thread> threads) {
        if (threads == null) {
            return null;
        }
        return threads.stream().filter(t -> t.getParent() == null).map(arg_0 -> this.mapThreadToDTO(arg_0)).collect(Collectors.toList());
    }

    protected List<ThreadDTO> mapThreadRepliesToDTO(List<Thread> replies) {
        if (replies == null) {
            return null;
        }
        return replies.stream().map(arg_0 -> this.mapThreadToDTO(arg_0)).collect(Collectors.toList());
    }

    protected Map<ReactionType, Long> calculateDiscussionReactionCounts(Discussion discussion) {
        List results = this.discussionReactionRepository.countByDiscussionGroupByReactionType(discussion);
        HashMap<ReactionType, Long> reactionCounts = new HashMap<ReactionType, Long>();
        if (results != null) {
            for (DiscussionCountByReactionDto r : results) {
                reactionCounts.put(r.getReaction(), r.getCount());
            }
        }
        return reactionCounts;
    }

    protected Map<ReactionType, Long> calculateThreadReactionCounts(Thread thread) {
        List results = this.threadReactionRepository.countByThreadGroupByReactionType(thread);
        HashMap<ReactionType, Long> reactionCounts = new HashMap<ReactionType, Long>();
        if (results != null) {
            for (ThreadCountByReactionDto r : results) {
                reactionCounts.put(r.getReaction(), r.getCount());
            }
        }
        return reactionCounts;
    }

    public Discussion updateEntity(Discussion existingDiscussion, DiscussionDTO discussionDTO) {
        if (existingDiscussion == null || discussionDTO == null) {
            return null;
        }
        existingDiscussion.setTitle(discussionDTO.getTitle());
        existingDiscussion.setContent(discussionDTO.getContent());
        existingDiscussion.setCreatedBy(discussionDTO.getCreatedBy());
        existingDiscussion.setCreatedAt(discussionDTO.getCreatedAt());
        existingDiscussion.setResourceId(discussionDTO.getResourceId());
        existingDiscussion.setResourceType(discussionDTO.getResourceType());
        existingDiscussion.setVisibility(discussionDTO.getVisibility());
        existingDiscussion.setUrl(discussionDTO.getUrl());
        return existingDiscussion;
    }
}

