package com.finconsgroup.itserr.marketplace.discussion.bs.mapper;

import com.finconsgroup.itserr.marketplace.discussion.bs.dto.OutputUserProfileDto;
import com.finconsgroup.itserr.marketplace.discussion.bs.dto.UserInfoDTO;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;

/**
 * Mapper for converting between OutputUserProfileDto and UserInfoDTO
 */
@Component
public class UserProfileMapper {

    /**
     * Maps OutputUserProfileDto to UserInfoDTO
     *
     * @param outputUserProfileDto the source DTO
     * @return mapped UserInfoDTO
     */
    public UserInfoDTO toUserInfoDTO(OutputUserProfileDto outputUserProfileDto) {
        if (outputUserProfileDto == null) {
            return null;
        }

        return UserInfoDTO.builder()
                .id(outputUserProfileDto.getId() != null ? outputUserProfileDto.getId().toString() : null)
                .firstName(outputUserProfileDto.getFirstName())
                .lastName(outputUserProfileDto.getLastName())
                .email(outputUserProfileDto.getEmail())
                .preferredUsername(outputUserProfileDto.getPreferredUsername())
                .imageUrl(outputUserProfileDto.getImageUrl())
                .shortBio(outputUserProfileDto.getShortBio())
                .build();
    }

    /**
     * Maps a list of OutputUserProfileDto to a list of UserInfoDTO
     *
     * @param outputUserProfileDtos the source DTO list
     * @return mapped UserInfoDTO list
     */
    public List<UserInfoDTO> toUserInfoDTOList(List<OutputUserProfileDto> outputUserProfileDtos) {
        if (outputUserProfileDtos == null) {
            return null;
        }

        return outputUserProfileDtos.stream()
                .map(this::toUserInfoDTO)
                .collect(Collectors.toList());
    }

    /**
     * Creates a default UserInfoDTO for cases where user lookup fails
     *
     * @param userId the user ID
     * @return default UserInfoDTO
     */
    public UserInfoDTO createDefaultUserInfo(String userId) {
        return UserInfoDTO.builder()
                .id(userId)
                .firstName("Unknown")
                .lastName("User")
                .shortBio("test short bio")
                .build();
    }
}
