/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.util;

import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionableUtil {
    public static boolean validVersion(String version) {
        if (version == null || version.length() == 0) {
            return false;
        }
        try {
            VersionableUtil.verifyVersion(version);
        }
        catch (Throwable th) {
            return false;
        }
        return true;
    }

    private static void verifyVersion(String version) {
        if (version == null) {
            throw new IllegalArgumentException("Null version supplied.");
        }
        if (version.equals("*")) {
            return;
        }
        Pattern p = Pattern.compile("([0-9])+(\\.([0-9])+)*");
        Matcher m = p.matcher(version);
        if (!m.matches()) {
            throw new IllegalArgumentException("Illegal in version supplied '" + version + "'");
        }
        if (version.length() > 10) {
            throw new IllegalArgumentException("Supplied version contains more characters than is allowed. The version can only be 10 characters at most.");
        }
    }

    public static String formatVersion(String version) {
        if (version == null) {
            return null;
        }
        VersionableUtil.verifyVersion(version);
        return version;
    }

    public static String incrementVersion(String version1, boolean majorIncrement) {
        String[] v1Comps = version1.split("\\.");
        Integer majorVersion = new Integer(v1Comps[0]);
        if (majorIncrement) {
            majorVersion = majorVersion + 1;
            return majorVersion + ".0";
        }
        Integer minorVersion = 0;
        if (v1Comps.length > 1) {
            minorVersion = new Integer(v1Comps[1]);
        }
        minorVersion = minorVersion + 1;
        return majorVersion + "." + minorVersion;
    }

    public static boolean isHigherVersion(String version1, String version2) {
        VersionableUtil.verifyVersion(version1);
        VersionableUtil.verifyVersion(version2);
        String[] v1Comps = version1.split("\\.");
        String[] v2Comps = version2.split("\\.");
        int limit = v1Comps.length > v2Comps.length ? v2Comps.length : v1Comps.length;
        for (int i = 0; i < limit; ++i) {
            BigDecimal part1int = new BigDecimal(v1Comps[i]);
            BigDecimal part2int = new BigDecimal(v2Comps[i]);
            int compare = part1int.compareTo(part2int);
            if (compare == 0) continue;
            return compare > 0;
        }
        return v1Comps.length > v2Comps.length;
    }
}

