/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.util.stax;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Date;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.sdmxsource.sdmx.util.date.DateUtil;
import org.sdmxsource.util.ObjectUtil;

public class StaxUtil {
    private static final String XML_NS = "http://www.w3.org/XML/1998/namespace";

    public static void writeHeader(XMLStreamWriter writer, String id, String senderId) throws XMLStreamException {
        writer.writeStartElement("Header");
        writer.writeStartElement("ID");
        writer.writeCharacters(id);
        writer.writeEndElement();
        writer.writeStartElement("Test");
        writer.writeCharacters("false");
        writer.writeEndElement();
        writer.writeStartElement("Prepared");
        writer.writeCharacters(DateUtil.formatDate(new Date()));
        writer.writeEndElement();
        writer.writeStartElement("Sender");
        writer.writeAttribute("id", senderId);
        writer.writeEndElement();
        writer.writeEndElement();
    }

    public static void copyNode(XMLStreamReader parser, boolean deepCopy, boolean includeCurrentNode, boolean includeNamespaces, XMLStreamWriter ... writers) throws XMLStreamException {
        if (writers == null || writers.length == 0) {
            throw new IllegalArgumentException("StxUtil.copyNode expects at least one XMLStreamWriter to copy to");
        }
        if (includeCurrentNode) {
            if (ObjectUtil.validString(parser.getNamespaceURI())) {
                for (XMLStreamWriter writer : writers) {
                    writer.writeStartElement(parser.getNamespaceURI(), parser.getLocalName());
                }
            } else {
                for (XMLStreamWriter writer : writers) {
                    writer.writeStartElement(parser.getLocalName());
                }
            }
            if (includeNamespaces) {
                for (int i = 0; i < parser.getNamespaceCount(); ++i) {
                    String nsPrefix = parser.getNamespacePrefix(i);
                    String nsUri = parser.getNamespaceURI(i);
                    for (XMLStreamWriter writer : writers) {
                        writer.writeNamespace(nsPrefix, nsUri);
                    }
                }
            }
            for (int i = 0; i < parser.getAttributeCount(); ++i) {
                String attNs = parser.getAttributeNamespace(i);
                String attName = parser.getAttributeLocalName(i);
                String attVal = parser.getAttributeValue(i);
                if (ObjectUtil.validString(attNs)) {
                    if (attNs.equals(XML_NS)) {
                        for (XMLStreamWriter writer : writers) {
                            writer.writeAttribute("xml", attNs, attName, attVal);
                        }
                        continue;
                    }
                    for (XMLStreamWriter writer : writers) {
                        writer.writeAttribute(attNs, attName, attVal);
                    }
                    continue;
                }
                for (XMLStreamWriter writer : writers) {
                    writer.writeAttribute(attName, attVal);
                }
            }
        }
        if (deepCopy) {
            while (parser.hasNext()) {
                int event = parser.next();
                if (event == 4) {
                    for (XMLStreamWriter writer : writers) {
                        writer.writeCharacters(parser.getText());
                    }
                    continue;
                }
                if (event == 1) {
                    StaxUtil.copyNode(parser, true, true, includeNamespaces, writers);
                    continue;
                }
                if (event != 2) continue;
                for (XMLStreamWriter writer : writers) {
                    writer.writeEndElement();
                }
                return;
            }
        }
    }

    public static void skipNode(XMLStreamReader parser) throws XMLStreamException {
        while (parser.hasNext()) {
            int event = parser.next();
            if (event == 1) {
                StaxUtil.skipNode(parser);
                continue;
            }
            if (event != 2) continue;
            return;
        }
    }

    public static boolean skipToNode(XMLStreamReader parser, String nodeName) throws XMLStreamException {
        while (parser.hasNext()) {
            int event = parser.next();
            if (event != 1) continue;
            if (parser.getLocalName().equals(nodeName)) {
                return true;
            }
            return StaxUtil.skipToNode(parser, nodeName);
        }
        return false;
    }

    public static boolean jumpToNode(XMLStreamReader parser, String findNodeName, String doNotProcessPastNodeName) throws XMLStreamException {
        while (parser.hasNext()) {
            String nodeName;
            int event = parser.next();
            if (event == 1 && (nodeName = parser.getLocalName()).equals(findNodeName)) {
                return true;
            }
            if (event != 2) continue;
            nodeName = parser.getLocalName();
            if (doNotProcessPastNodeName == null || !nodeName.equals(doNotProcessPastNodeName)) continue;
            return false;
        }
        return false;
    }

    public static boolean skipToEndNode(XMLStreamReader parser, String nodeName) throws XMLStreamException {
        while (parser.hasNext()) {
            int event = parser.next();
            if (event != 2 || !parser.getLocalName().equals(nodeName)) continue;
            return true;
        }
        return false;
    }

    public static String parseString(XMLStreamReader parser) throws XMLStreamException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XMLOutputFactory xmlOutputfactory = XMLOutputFactory.newInstance();
        XMLStreamWriter writer = xmlOutputfactory.createXMLStreamWriter(out);
        writer.writeStartDocument();
        boolean started = false;
        int event = 1;
        String endElement = parser.getLocalName();
        int level = 0;
        while (true) {
            switch (event) {
                case 1: {
                    if (parser.getLocalName().equals(endElement)) {
                        ++level;
                    }
                    writer.writeStartElement(parser.getNamespaceURI(), parser.getLocalName());
                    if (!started) {
                        writer.writeNamespace("xml", XML_NS);
                        started = true;
                    }
                    for (int i = 0; i < parser.getAttributeCount(); ++i) {
                        if (parser.getAttributeNamespace(i) == null) {
                            writer.writeAttribute(parser.getAttributeLocalName(i), parser.getAttributeValue(i));
                            continue;
                        }
                        writer.writeAttribute(parser.getAttributeNamespace(i), parser.getAttributeLocalName(i), parser.getAttributeValue(i));
                    }
                    break;
                }
                case 4: {
                    writer.writeCharacters(parser.getText());
                    break;
                }
                case 2: {
                    writer.writeEndElement();
                    if (!parser.getLocalName().equals(endElement)) break;
                    if (level == 1) {
                        writer.flush();
                        writer.close();
                        return out.toString();
                    }
                    --level;
                }
            }
            event = parser.next();
        }
    }

    public static void isSameXML(InputStream xmlOne, InputStream xmlTwo, String ignoreAttrValue, String ... ignoreNodes) throws Exception {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLStreamReader parser1 = factory.createXMLStreamReader(xmlOne, "UTF-8");
        XMLStreamReader parser2 = factory.createXMLStreamReader(xmlTwo, "UTF-8");
        String nodeA = null;
        String nodeB = null;
        int element = 0;
        int a = -1;
        int b = -1;
        block0: while (parser1.hasNext()) {
            boolean found;
            int i;
            a = parser1.next();
            b = parser2.next();
            while (a == 6) {
                a = parser1.next();
            }
            while (b == 6) {
                b = parser2.next();
            }
            if (parser1.isCharacters()) {
                if (ObjectUtil.validString(parser1.getText())) {
                    if (!parser2.isCharacters()) {
                        throw new IllegalArgumentException("Text Differs on Node:" + nodeA);
                    }
                    if (!parser1.getText().equals(parser2.getText())) {
                        throw new IllegalArgumentException("Text Differs on Node:" + nodeA + "\nExpected:" + parser1.getText() + "\nActual:" + parser2.getText());
                    }
                } else {
                    a = parser1.next();
                    if (parser2.isCharacters() && !ObjectUtil.validString(parser2.getText())) {
                        b = parser2.next();
                    }
                }
            } else if (parser2.isCharacters()) {
                if (ObjectUtil.validString(parser2.getText())) {
                    throw new IllegalArgumentException("Text Differs on Node:" + nodeA + " : " + parser2.getText());
                }
                b = parser2.next();
            }
            if (a == 2) {
                if (b == a) continue;
                nodeA = parser1.getLocalName();
                throw new IllegalArgumentException("Input A is ending XML element: " + nodeA + " whilst input B is not");
            }
            if (a != 1) continue;
            ++element;
            nodeA = parser1.getLocalName();
            if (b != 1) {
                while (parser2.hasNext()) {
                    b = parser2.next();
                    if (b != 1) continue;
                    nodeB = parser2.getLocalName();
                    break;
                }
            }
            if (b != 1) {
                throw new IllegalArgumentException("Parser B end of document, Parser A on node: " + nodeA);
            }
            nodeB = parser2.getLocalName();
            if (!nodeA.equals(nodeB)) {
                throw new IllegalArgumentException("XML NODES DIFFER: " + nodeA + "," + nodeB);
            }
            for (String ignoreNode : ignoreNodes) {
                if (!nodeA.equals(ignoreNode)) continue;
                StaxUtil.skipNode(parser1);
                StaxUtil.skipNode(parser2);
                continue block0;
            }
            if (parser1.getNamespaceCount() != parser2.getNamespaceCount()) {
                int i2;
                StringBuilder sb = new StringBuilder();
                sb.append("Namespace count for parser 1 : " + parser1.getNamespaceCount() + "\n");
                for (i2 = 0; i2 < parser1.getNamespaceCount(); ++i2) {
                    sb.append("Parser 1 Namespace #" + (i2 + 1) + ":  " + parser1.getNamespaceURI(i2) + "\n");
                }
                sb.append("Namespace count for parser 2 : " + parser2.getNamespaceCount() + "\n");
                for (i2 = 0; i2 < parser2.getNamespaceCount(); ++i2) {
                    sb.append("Parser 2 Namespace #" + (i2 + 1) + ":  " + parser2.getNamespaceURI(i2) + "\n");
                }
                throw new IllegalArgumentException("Namespace count differs on node:" + nodeA + "\n" + sb.toString());
            }
            for (i = 0; i < parser1.getNamespaceCount(); ++i) {
                found = false;
                String nameSpaceURI = parser1.getNamespaceURI(i);
                for (int j = 0; j < parser2.getNamespaceCount(); ++j) {
                    if (!parser2.getNamespaceURI(j).equals(nameSpaceURI)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                throw new IllegalArgumentException("Namespace not found " + nameSpaceURI);
            }
            if (parser1.getAttributeCount() != parser2.getAttributeCount()) {
                throw new IllegalArgumentException("Attribute count differs on node:" + nodeA);
            }
            for (i = 0; i < parser1.getAttributeCount(); ++i) {
                int j;
                found = false;
                String attributeLocalName = parser1.getAttributeLocalName(i);
                String attributeNameSpace = parser1.getAttributeNamespace(i);
                String attributeValue = parser1.getAttributeValue(i);
                for (j = 0; j < parser2.getAttributeCount(); ++j) {
                    if (!parser2.getAttributeLocalName(j).equals(attributeLocalName)) continue;
                    if (attributeNameSpace != null || parser2.getAttributeNamespace(j) != null) {
                        if (attributeNameSpace == null && parser2.getAttributeNamespace(j) != null) {
                            throw new IllegalArgumentException("ATTRIBUTE NAMESPACE DIFFERS " + parser2.getAttributeNamespace(i) + "," + attributeNameSpace);
                        }
                        if (attributeNameSpace != null && parser2.getAttributeNamespace(j) == null) {
                            throw new IllegalArgumentException("ATTRIBUTE NAMESPACE DIFFERS " + parser2.getAttributeNamespace(i) + "," + attributeNameSpace);
                        }
                        if (!parser2.getAttributeNamespace(j).equals(attributeNameSpace)) {
                            throw new IllegalArgumentException("ATTRIBUTE NAMESPACE DIFFERS " + parser2.getAttributeNamespace(i) + "," + attributeNameSpace);
                        }
                    }
                    found = true;
                    break;
                }
                if (!found) {
                    throw new IllegalArgumentException("ATTRIBUTE NOT FOUND ON NODE '" + nodeA + "' : " + attributeLocalName);
                }
                if (attributeValue.equals(ignoreAttrValue) || parser2.getAttributeValue(j).equals(attributeValue)) continue;
                String line_separator = System.getProperty("line.separator");
                throw new IllegalArgumentException("ATTRIBUTE VALUE DIFFERS on NODE :" + element + line_separator + attributeValue + line_separator + parser2.getAttributeValue(i));
            }
        }
    }
}

