/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.util.beans.container;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.sdmxsource.sdmx.api.exception.SdmxNotImplementedException;
import org.sdmxsource.sdmx.api.model.superbeans.SuperBeans;
import org.sdmxsource.sdmx.api.model.superbeans.base.MaintainableSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.categoryscheme.CategorySchemeSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.codelist.CodelistSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.codelist.HierarchicalCodelistSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.conceptscheme.ConceptSchemeSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.DataStructureSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.DataflowSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.metadata.MetadataStructureSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.process.ProcessSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.registry.ProvisionAgreementSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.registry.RegistrationSuperBean;

public class SuperBeansImpl
implements SuperBeans {
    private Set<CategorySchemeSuperBean> categorySchemes = new HashSet<CategorySchemeSuperBean>();
    private Set<CodelistSuperBean> codelists = new HashSet<CodelistSuperBean>();
    private Set<ConceptSchemeSuperBean> conceptSchemes = new HashSet<ConceptSchemeSuperBean>();
    private Set<DataflowSuperBean> dataflows = new HashSet<DataflowSuperBean>();
    private Set<HierarchicalCodelistSuperBean> hcls = new HashSet<HierarchicalCodelistSuperBean>();
    private Set<DataStructureSuperBean> dataStructures = new HashSet<DataStructureSuperBean>();
    private Set<MetadataStructureSuperBean> msdSuperBean = new HashSet<MetadataStructureSuperBean>();
    private Set<ProvisionAgreementSuperBean> provisionAgreement = new HashSet<ProvisionAgreementSuperBean>();
    private Set<ProcessSuperBean> processes = new HashSet<ProcessSuperBean>();
    private Set<RegistrationSuperBean> registrations = new HashSet<RegistrationSuperBean>();

    public SuperBeansImpl() {
    }

    public SuperBeansImpl(Collection<MaintainableSuperBean> allBeans) {
        if (allBeans != null) {
            for (MaintainableSuperBean currentBean : allBeans) {
                this.addMaintainable(currentBean);
            }
        }
    }

    public SuperBeansImpl(SuperBeans ... beans) {
        for (SuperBeans currentBean : beans) {
            this.categorySchemes.addAll(currentBean.getCategorySchemes());
            this.codelists.addAll(currentBean.getCodelists());
            this.conceptSchemes.addAll(currentBean.getConceptSchemes());
            this.dataflows.addAll(currentBean.getDataflows());
            this.hcls.addAll(currentBean.getHierarchicalCodelists());
            this.dataStructures.addAll(currentBean.getDataStructures());
            this.msdSuperBean.addAll(currentBean.getMetadataStructures());
            this.provisionAgreement.addAll(currentBean.getProvisions());
            this.processes.addAll(currentBean.getProcesses());
            this.registrations.addAll(currentBean.getRegistartions());
        }
    }

    public void merge(SuperBeans superBeans) {
        for (MaintainableSuperBean currentSb : superBeans.getAllMaintainables()) {
            this.addMaintainable(currentSb);
        }
    }

    public void addMaintainable(MaintainableSuperBean bean) {
        switch (bean.getBuiltFrom().getStructureType()) {
            case CATEGORY_SCHEME: {
                this.addCategoryScheme((CategorySchemeSuperBean)bean);
                break;
            }
            case CODE_LIST: {
                this.addCodelist((CodelistSuperBean)bean);
                break;
            }
            case CONCEPT_SCHEME: {
                this.addConceptScheme((ConceptSchemeSuperBean)bean);
                break;
            }
            case DATAFLOW: {
                this.addDataflow((DataflowSuperBean)bean);
                break;
            }
            case HIERARCHICAL_CODELIST: {
                this.addHierarchicalCodelist((HierarchicalCodelistSuperBean)bean);
                break;
            }
            case DSD: {
                this.addDataStructure((DataStructureSuperBean)bean);
                break;
            }
            case MSD: {
                this.addMetadataStructure((MetadataStructureSuperBean)bean);
                break;
            }
            case PROCESS: {
                this.addProcess((ProcessSuperBean)bean);
                break;
            }
            case PROVISION_AGREEMENT: {
                this.addHierarchicalCodelist((HierarchicalCodelistSuperBean)bean);
                break;
            }
            case REGISTRATION: {
                this.addRegistration((RegistrationSuperBean)bean);
                break;
            }
            default: {
                throw new SdmxNotImplementedException("SuperBeansImpl.addMaintainable of type : " + bean.getBuiltFrom().getStructureType().getType());
            }
        }
    }

    public void addCategoryScheme(CategorySchemeSuperBean bean) {
        if (bean != null) {
            this.categorySchemes.remove(bean);
            this.categorySchemes.add(bean);
        }
    }

    public void addCodelist(CodelistSuperBean bean) {
        if (bean != null) {
            this.codelists.remove(bean);
            this.codelists.add(bean);
        }
    }

    public void addConceptScheme(ConceptSchemeSuperBean bean) {
        if (bean != null) {
            this.conceptSchemes.remove(bean);
            this.conceptSchemes.add(bean);
        }
    }

    public void addDataflow(DataflowSuperBean bean) {
        if (bean != null) {
            this.dataflows.remove(bean);
            this.dataflows.add(bean);
        }
    }

    public void addHierarchicalCodelist(HierarchicalCodelistSuperBean bean) {
        if (bean != null) {
            this.hcls.remove(bean);
            this.hcls.add(bean);
        }
    }

    public void addDataStructure(DataStructureSuperBean bean) {
        if (bean != null) {
            this.dataStructures.remove(bean);
            this.dataStructures.add(bean);
        }
    }

    public void addMetadataStructure(MetadataStructureSuperBean bean) {
        if (bean != null) {
            this.msdSuperBean.remove(bean);
            this.msdSuperBean.add(bean);
        }
    }

    public void addProvision(ProvisionAgreementSuperBean bean) {
        if (bean != null) {
            this.provisionAgreement.remove(bean);
            this.provisionAgreement.add(bean);
        }
    }

    public void addProcess(ProcessSuperBean bean) {
        if (bean != null) {
            this.processes.remove(bean);
            this.processes.add(bean);
        }
    }

    public void addRegistration(RegistrationSuperBean bean) {
        if (bean != null) {
            this.registrations.remove(bean);
            this.registrations.add(bean);
        }
    }

    public Set<CategorySchemeSuperBean> getCategorySchemes() {
        return new HashSet<CategorySchemeSuperBean>(this.categorySchemes);
    }

    public Set<CodelistSuperBean> getCodelists() {
        return new HashSet<CodelistSuperBean>(this.codelists);
    }

    public Set<ConceptSchemeSuperBean> getConceptSchemes() {
        return new HashSet<ConceptSchemeSuperBean>(this.conceptSchemes);
    }

    public Set<DataflowSuperBean> getDataflows() {
        return new HashSet<DataflowSuperBean>(this.dataflows);
    }

    public Set<HierarchicalCodelistSuperBean> getHierarchicalCodelists() {
        return new HashSet<HierarchicalCodelistSuperBean>(this.hcls);
    }

    public Set<DataStructureSuperBean> getDataStructures() {
        return new HashSet<DataStructureSuperBean>(this.dataStructures);
    }

    public Set<MetadataStructureSuperBean> getMetadataStructures() {
        return new HashSet<MetadataStructureSuperBean>(this.msdSuperBean);
    }

    public Set<ProvisionAgreementSuperBean> getProvisions() {
        return new HashSet<ProvisionAgreementSuperBean>(this.provisionAgreement);
    }

    public Set<ProcessSuperBean> getProcesses() {
        return new HashSet<ProcessSuperBean>(this.processes);
    }

    public Set<RegistrationSuperBean> getRegistartions() {
        return new HashSet<RegistrationSuperBean>(this.registrations);
    }

    public void removeCategoryScheme(CategorySchemeSuperBean bean) {
        this.categorySchemes.remove(bean);
    }

    public void removeCodelist(CodelistSuperBean bean) {
        this.codelists.remove(bean);
    }

    public void removeConceptScheme(ConceptSchemeSuperBean bean) {
        this.conceptSchemes.remove(bean);
    }

    public void removeDataflow(DataflowSuperBean bean) {
        this.dataflows.remove(bean);
    }

    public void removeHierarchicalCodelist(HierarchicalCodelistSuperBean bean) {
        this.hcls.remove(bean);
    }

    public void removeDataStructure(DataStructureSuperBean bean) {
        this.dataStructures.remove(bean);
    }

    public void removeMetadataStructure(MetadataStructureSuperBean bean) {
        this.msdSuperBean.remove(bean);
    }

    public void removeProvision(ProvisionAgreementSuperBean bean) {
        this.provisionAgreement.remove(bean);
    }

    public void removeProcess(ProcessSuperBean bean) {
        this.processes.remove(bean);
    }

    public void removeRegistration(RegistrationSuperBean bean) {
        this.registrations.remove(bean);
    }

    public Set<MaintainableSuperBean> getAllMaintainables() {
        HashSet<MaintainableSuperBean> returnSet = new HashSet<MaintainableSuperBean>();
        returnSet.addAll(this.categorySchemes);
        returnSet.addAll(this.codelists);
        returnSet.addAll(this.conceptSchemes);
        returnSet.addAll(this.dataflows);
        returnSet.addAll(this.hcls);
        returnSet.addAll(this.msdSuperBean);
        returnSet.addAll(this.dataStructures);
        returnSet.addAll(this.provisionAgreement);
        returnSet.addAll(this.processes);
        returnSet.addAll(this.registrations);
        return returnSet;
    }
}

