/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.util.beans.container;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.sdmxsource.sdmx.api.constants.DATASET_ACTION;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxNotImplementedException;
import org.sdmxsource.sdmx.api.model.beans.AgencyMetadata;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeansInfo;
import org.sdmxsource.sdmx.api.model.beans.base.AgencyBean;
import org.sdmxsource.sdmx.api.model.beans.base.AgencySchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.DataConsumerSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.DataProviderSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.base.OrganisationUnitSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.CategorisationBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.CategorySchemeBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.ReportingTaxonomyBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.HierarchicalCodelistBean;
import org.sdmxsource.sdmx.api.model.beans.conceptscheme.ConceptSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataflowBean;
import org.sdmxsource.sdmx.api.model.beans.mapping.StructureSetBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.MetadataFlowBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.MetadataStructureDefinitionBean;
import org.sdmxsource.sdmx.api.model.beans.process.ProcessBean;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.beans.registry.AttachmentConstraintBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ContentConstraintBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ProvisionAgreementBean;
import org.sdmxsource.sdmx.api.model.beans.registry.RegistrationBean;
import org.sdmxsource.sdmx.api.model.beans.registry.SubscriptionBean;
import org.sdmxsource.sdmx.api.model.header.HeaderBean;
import org.sdmxsource.sdmx.api.model.mutable.MutableBeans;
import org.sdmxsource.sdmx.api.model.mutable.base.IdentifiableMutableBean;
import org.sdmxsource.sdmx.util.beans.container.AgencyMetadataImpl;
import org.sdmxsource.sdmx.util.beans.container.MutableBeansImpl;
import org.sdmxsource.sdmx.util.beans.container.SdmxBeansInfoImpl;
import org.sdmxsource.sdmx.util.beans.reference.StructureReferenceBeanImpl;
import org.sdmxsource.sdmx.util.sort.MaintainableSortByIdentifiers;
import org.sdmxsource.util.ObjectUtil;

public class SdmxBeansImpl
implements SdmxBeans {
    private static final long serialVersionUID = 5981995104378086631L;
    private String id = UUID.randomUUID().toString();
    private DATASET_ACTION action = DATASET_ACTION.INFORMATION;
    private HeaderBean header;
    private Set<AgencySchemeBean> agencySchemes = new HashSet<AgencySchemeBean>();
    private Set<OrganisationUnitSchemeBean> organisationUnitSchemes = new HashSet<OrganisationUnitSchemeBean>();
    private Set<DataProviderSchemeBean> dataProviderSchemes = new HashSet<DataProviderSchemeBean>();
    private Set<DataConsumerSchemeBean> dataConsumerSchemes = new HashSet<DataConsumerSchemeBean>();
    private Set<AttachmentConstraintBean> attachmentConstraints = new HashSet<AttachmentConstraintBean>();
    private Set<ContentConstraintBean> contentConstraints = new HashSet<ContentConstraintBean>();
    private Set<CategorySchemeBean> categorySchemes = new HashSet<CategorySchemeBean>();
    private Set<CodelistBean> codelists = new HashSet<CodelistBean>();
    private Set<ConceptSchemeBean> conceptSchemes = new HashSet<ConceptSchemeBean>();
    private Set<DataflowBean> dataflows = new HashSet<DataflowBean>();
    private Set<HierarchicalCodelistBean> hcls = new HashSet<HierarchicalCodelistBean>();
    private Set<DataStructureBean> dataStructures = new HashSet<DataStructureBean>();
    private Set<MetadataFlowBean> metadataflows = new HashSet<MetadataFlowBean>();
    private Set<MetadataStructureDefinitionBean> metadataStructures = new HashSet<MetadataStructureDefinitionBean>();
    private Set<ProcessBean> processes = new HashSet<ProcessBean>();
    private Set<StructureSetBean> structureSet = new HashSet<StructureSetBean>();
    private Set<ReportingTaxonomyBean> reportingTaxonomy = new HashSet<ReportingTaxonomyBean>();
    private Set<CategorisationBean> categorisation = new HashSet<CategorisationBean>();
    private Set<ProvisionAgreementBean> provisionAgreement = new HashSet<ProvisionAgreementBean>();
    private Set<RegistrationBean> registrations = new HashSet<RegistrationBean>();
    private Set<SubscriptionBean> subscriptions = new HashSet<SubscriptionBean>();

    public SdmxBeansImpl() {
    }

    public SdmxBeansImpl(DATASET_ACTION action) {
        this.action = action;
    }

    public SdmxBeansImpl(HeaderBean header) {
        this.header = header;
    }

    public SdmxBeansImpl(HeaderBean header, DATASET_ACTION action) {
        this.header = header;
        this.action = action;
    }

    public SdmxBeansImpl(HeaderBean header, Collection<? extends MaintainableBean> maintainables) {
        this.header = header;
        if (maintainables != null) {
            for (MaintainableBean maintainableBean : maintainables) {
                this.addIdentifiable((IdentifiableBean)maintainableBean);
            }
        }
    }

    public SdmxBeansImpl(SdmxBeans ... beans) {
        for (SdmxBeans currentBean : beans) {
            this.merge(currentBean);
        }
    }

    public SdmxBeansImpl(MaintainableBean ... maintainableBeans) {
        if (maintainableBeans != null) {
            for (MaintainableBean currentMaint : maintainableBeans) {
                this.addIdentifiable((IdentifiableBean)currentMaint);
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public HeaderBean getHeader() {
        return this.header;
    }

    public void setHeader(HeaderBean header) {
        this.header = header;
    }

    public DATASET_ACTION getAction() {
        return this.action;
    }

    public void setAction(DATASET_ACTION action) {
        this.action = action;
    }

    public MutableBeans getMutableBeans() {
        MutableBeansImpl returnBeans = new MutableBeansImpl();
        for (MaintainableBean currentMaint : this.getAllMaintainables()) {
            returnBeans.addIdentifiable((IdentifiableMutableBean)currentMaint.getMutableInstance());
        }
        return returnBeans;
    }

    public boolean hasStructures() {
        return this.getAllMaintainables(SDMX_STRUCTURE_TYPE.REGISTRATION, SDMX_STRUCTURE_TYPE.SUBSCRIPTION).size() > 0;
    }

    public boolean hasSubscriptions() {
        return this.subscriptions.size() > 0;
    }

    public boolean hasRegistrations() {
        return this.registrations.size() > 0;
    }

    public void merge(SdmxBeans beans) {
        if (beans.getHeader() != null) {
            this.header = beans.getHeader();
        }
        if (beans.getAction() != null) {
            this.action = beans.getAction();
        }
        this.agencySchemes.removeAll(beans.getAgenciesSchemes());
        this.attachmentConstraints.removeAll(beans.getAttachmentConstraints());
        this.contentConstraints.removeAll(beans.getContentConstraintBeans());
        this.dataConsumerSchemes.removeAll(beans.getDataConsumerSchemes());
        this.dataProviderSchemes.removeAll(beans.getDataProviderSchemes());
        this.categorySchemes.removeAll(beans.getCategorySchemes());
        this.codelists.removeAll(beans.getCodelists());
        this.conceptSchemes.removeAll(beans.getConceptSchemes());
        this.dataflows.removeAll(beans.getDataflows());
        this.hcls.removeAll(beans.getHierarchicalCodelists());
        this.dataStructures.removeAll(beans.getDataStructures());
        this.metadataflows.removeAll(beans.getMetadataflows());
        this.metadataStructures.removeAll(beans.getMetadataStructures());
        this.organisationUnitSchemes.removeAll(beans.getOrganisationUnitSchemes());
        this.processes.removeAll(beans.getProcesses());
        this.structureSet.removeAll(beans.getStructureSets());
        this.reportingTaxonomy.removeAll(beans.getReportingTaxonomys());
        this.categorisation.removeAll(beans.getCategorisations());
        this.provisionAgreement.removeAll(beans.getProvisionAgreements());
        this.registrations.removeAll(beans.getRegistrations());
        this.subscriptions.removeAll(beans.getSubscriptions());
        this.agencySchemes.addAll(beans.getAgenciesSchemes());
        this.attachmentConstraints.addAll(beans.getAttachmentConstraints());
        this.contentConstraints.addAll(beans.getContentConstraintBeans());
        this.dataConsumerSchemes.addAll(beans.getDataConsumerSchemes());
        this.dataProviderSchemes.addAll(beans.getDataProviderSchemes());
        this.categorySchemes.addAll(beans.getCategorySchemes());
        this.codelists.addAll(beans.getCodelists());
        this.conceptSchemes.addAll(beans.getConceptSchemes());
        this.dataflows.addAll(beans.getDataflows());
        this.hcls.addAll(beans.getHierarchicalCodelists());
        this.dataStructures.addAll(beans.getDataStructures());
        this.metadataflows.addAll(beans.getMetadataflows());
        this.metadataStructures.addAll(beans.getMetadataStructures());
        this.organisationUnitSchemes.addAll(beans.getOrganisationUnitSchemes());
        this.processes.addAll(beans.getProcesses());
        this.structureSet.addAll(beans.getStructureSets());
        this.reportingTaxonomy.addAll(beans.getReportingTaxonomys());
        this.categorisation.addAll(beans.getCategorisations());
        this.provisionAgreement.addAll(beans.getProvisionAgreements());
        this.registrations.addAll(beans.getRegistrations());
        this.subscriptions.addAll(beans.getSubscriptions());
    }

    public void addIdentifiables(Collection<? extends IdentifiableBean> beans) {
        for (IdentifiableBean identifiableBean : beans) {
            this.addIdentifiable(identifiableBean);
        }
    }

    public void addIdentifiable(IdentifiableBean bean) {
        if (bean == null) {
            return;
        }
        if (bean instanceof AgencySchemeBean) {
            this.addAgencyScheme((AgencySchemeBean)bean);
        } else if (bean instanceof AttachmentConstraintBean) {
            this.addAttachmentConstraint((AttachmentConstraintBean)bean);
        } else if (bean instanceof ContentConstraintBean) {
            this.addContentConstraintBean((ContentConstraintBean)bean);
        } else if (bean instanceof DataConsumerSchemeBean) {
            this.addDataConsumerScheme((DataConsumerSchemeBean)bean);
        } else if (bean instanceof DataProviderSchemeBean) {
            this.addDataProviderScheme((DataProviderSchemeBean)bean);
        } else if (bean instanceof CategorySchemeBean) {
            this.addCategoryScheme((CategorySchemeBean)bean);
        } else if (bean instanceof CodelistBean) {
            this.addCodelist((CodelistBean)bean);
        } else if (bean instanceof ConceptSchemeBean) {
            this.addConceptScheme((ConceptSchemeBean)bean);
        } else if (bean instanceof DataflowBean) {
            this.addDataflow((DataflowBean)bean);
        } else if (bean instanceof HierarchicalCodelistBean) {
            this.addHierarchicalCodelist((HierarchicalCodelistBean)bean);
        } else if (bean instanceof DataStructureBean) {
            this.addDataStructure((DataStructureBean)bean);
        } else if (bean instanceof MetadataFlowBean) {
            this.addMetadataFlow((MetadataFlowBean)bean);
        } else if (bean instanceof MetadataStructureDefinitionBean) {
            this.addMetadataStructure((MetadataStructureDefinitionBean)bean);
        } else if (bean instanceof OrganisationUnitSchemeBean) {
            this.addOrganisationUnitScheme((OrganisationUnitSchemeBean)bean);
        } else if (bean instanceof StructureSetBean) {
            this.addStructureSet((StructureSetBean)bean);
        } else if (bean instanceof ProcessBean) {
            this.addProcess((ProcessBean)bean);
        } else if (bean instanceof ReportingTaxonomyBean) {
            this.addReportingTaxonomy((ReportingTaxonomyBean)bean);
        } else if (bean instanceof CategorisationBean) {
            this.addCategorisation((CategorisationBean)bean);
        } else if (bean instanceof ProvisionAgreementBean) {
            this.addProvisionAgreement((ProvisionAgreementBean)bean);
        } else if (bean instanceof RegistrationBean) {
            this.addRegistration((RegistrationBean)bean);
        } else if (bean instanceof SubscriptionBean) {
            this.addSubscription((SubscriptionBean)bean);
        } else if (bean.getIdentifiableParent() != null) {
            this.addIdentifiable(bean.getIdentifiableParent());
        } else {
            throw new IllegalArgumentException("Could not add bean " + bean.getUrn() + " to SdmxBeans Container");
        }
    }

    public SdmxBeansInfo getSdmxBeansInfo() {
        SdmxBeansInfoImpl info = new SdmxBeansInfoImpl();
        ArrayList<AgencyMetadata> agencyMetadataList = new ArrayList<AgencyMetadata>();
        HashSet<String> allAgencies = new HashSet<String>();
        for (MaintainableBean currentMaint : this.getAllMaintainables()) {
            allAgencies.add(currentMaint.getAgencyId());
        }
        for (String currentAgencyId : allAgencies) {
            AgencyMetadataImpl agencyMetadata = new AgencyMetadataImpl(currentAgencyId, this);
            agencyMetadataList.add(agencyMetadata);
        }
        info.setAgencyMetadata(agencyMetadataList);
        return info;
    }

    public Set<MaintainableBean> getMaintainables(AgencyBean agency) {
        TreeSet<MaintainableBean> returnSet = new TreeSet<MaintainableBean>(new MaintainableSortByIdentifiers());
        this.addAgencyMaintainedStructuresToSet(returnSet, agency, this.agencySchemes);
        this.addAgencyMaintainedStructuresToSet(returnSet, agency, this.dataProviderSchemes);
        this.addAgencyMaintainedStructuresToSet(returnSet, agency, this.dataConsumerSchemes);
        this.addAgencyMaintainedStructuresToSet(returnSet, agency, this.categorySchemes);
        this.addAgencyMaintainedStructuresToSet(returnSet, agency, this.codelists);
        this.addAgencyMaintainedStructuresToSet(returnSet, agency, this.conceptSchemes);
        this.addAgencyMaintainedStructuresToSet(returnSet, agency, this.dataflows);
        this.addAgencyMaintainedStructuresToSet(returnSet, agency, this.hcls);
        this.addAgencyMaintainedStructuresToSet(returnSet, agency, this.dataStructures);
        this.addAgencyMaintainedStructuresToSet(returnSet, agency, this.metadataflows);
        this.addAgencyMaintainedStructuresToSet(returnSet, agency, this.metadataStructures);
        this.addAgencyMaintainedStructuresToSet(returnSet, agency, this.organisationUnitSchemes);
        this.addAgencyMaintainedStructuresToSet(returnSet, agency, this.processes);
        this.addAgencyMaintainedStructuresToSet(returnSet, agency, this.structureSet);
        this.addAgencyMaintainedStructuresToSet(returnSet, agency, this.reportingTaxonomy);
        this.addAgencyMaintainedStructuresToSet(returnSet, agency, this.categorisation);
        this.addAgencyMaintainedStructuresToSet(returnSet, agency, this.attachmentConstraints);
        this.addAgencyMaintainedStructuresToSet(returnSet, agency, this.contentConstraints);
        this.addAgencyMaintainedStructuresToSet(returnSet, agency, this.registrations);
        this.addAgencyMaintainedStructuresToSet(returnSet, agency, this.subscriptions);
        return returnSet;
    }

    private void addAgencyMaintainedStructuresToSet(Set<MaintainableBean> toAdd, AgencyBean agency, Set<? extends MaintainableBean> walkSet) {
        String agencyId = agency.getId();
        for (MaintainableBean maintainableBean : walkSet) {
            if (!maintainableBean.getAgencyId().equals(agencyId)) continue;
            toAdd.add(maintainableBean);
        }
    }

    public Set<MaintainableBean> getAllMaintainables() {
        TreeSet<MaintainableBean> returnSet = new TreeSet<MaintainableBean>(new MaintainableSortByIdentifiers());
        for (SDMX_STRUCTURE_TYPE currentType : SDMX_STRUCTURE_TYPE.values()) {
            if (!currentType.isMaintainable()) continue;
            returnSet.addAll(this.getMaintainables(currentType));
        }
        return returnSet;
    }

    public Set<MaintainableBean> getAllMaintainables(SDMX_STRUCTURE_TYPE ... exclude) {
        TreeSet<MaintainableBean> returnSet = new TreeSet<MaintainableBean>(new MaintainableSortByIdentifiers());
        block0: for (SDMX_STRUCTURE_TYPE currentType : SDMX_STRUCTURE_TYPE.getMaintainableStructureTypes()) {
            if (exclude != null) {
                for (SDMX_STRUCTURE_TYPE currentExclude : exclude) {
                    if (currentExclude == currentType) continue block0;
                }
            }
            if (!currentType.isMaintainable() || currentType == SDMX_STRUCTURE_TYPE.METADATA_SET) continue;
            returnSet.addAll(this.getMaintainables(currentType));
        }
        return returnSet;
    }

    public Set<MaintainableBean> getMaintainables(SDMX_STRUCTURE_TYPE structureType) {
        TreeSet<MaintainableBean> returnSet = new TreeSet<MaintainableBean>(new MaintainableSortByIdentifiers());
        if (structureType == SDMX_STRUCTURE_TYPE.AGENCY_SCHEME) {
            returnSet.addAll(this.agencySchemes);
            return returnSet;
        }
        if (structureType == SDMX_STRUCTURE_TYPE.DATA_PROVIDER_SCHEME) {
            returnSet.addAll(this.dataProviderSchemes);
            return returnSet;
        }
        if (structureType == SDMX_STRUCTURE_TYPE.DATA_CONSUMER_SCHEME) {
            returnSet.addAll(this.dataConsumerSchemes);
            return returnSet;
        }
        if (structureType == SDMX_STRUCTURE_TYPE.CATEGORY_SCHEME) {
            returnSet.addAll(this.categorySchemes);
            return returnSet;
        }
        if (structureType == SDMX_STRUCTURE_TYPE.CODE_LIST) {
            returnSet.addAll(this.codelists);
            return returnSet;
        }
        if (structureType == SDMX_STRUCTURE_TYPE.CONCEPT_SCHEME) {
            returnSet.addAll(this.conceptSchemes);
            return returnSet;
        }
        if (structureType == SDMX_STRUCTURE_TYPE.DATAFLOW) {
            returnSet.addAll(this.dataflows);
            return returnSet;
        }
        if (structureType == SDMX_STRUCTURE_TYPE.HIERARCHICAL_CODELIST) {
            returnSet.addAll(this.hcls);
            return returnSet;
        }
        if (structureType == SDMX_STRUCTURE_TYPE.DSD) {
            returnSet.addAll(this.dataStructures);
            return returnSet;
        }
        if (structureType == SDMX_STRUCTURE_TYPE.METADATA_FLOW) {
            returnSet.addAll(this.metadataflows);
            return returnSet;
        }
        if (structureType == SDMX_STRUCTURE_TYPE.MSD) {
            returnSet.addAll(this.metadataStructures);
            return returnSet;
        }
        if (structureType == SDMX_STRUCTURE_TYPE.ORGANISATION_UNIT_SCHEME) {
            returnSet.addAll(this.organisationUnitSchemes);
            return returnSet;
        }
        if (structureType == SDMX_STRUCTURE_TYPE.PROCESS) {
            returnSet.addAll(this.processes);
            return returnSet;
        }
        if (structureType == SDMX_STRUCTURE_TYPE.STRUCTURE_SET) {
            returnSet.addAll(this.structureSet);
            return returnSet;
        }
        if (structureType == SDMX_STRUCTURE_TYPE.REPORTING_TAXONOMY) {
            returnSet.addAll(this.reportingTaxonomy);
            return returnSet;
        }
        if (structureType == SDMX_STRUCTURE_TYPE.CATEGORISATION) {
            returnSet.addAll(this.categorisation);
            return returnSet;
        }
        if (structureType == SDMX_STRUCTURE_TYPE.PROVISION_AGREEMENT) {
            returnSet.addAll(this.provisionAgreement);
            return returnSet;
        }
        if (structureType == SDMX_STRUCTURE_TYPE.ATTACHMENT_CONSTRAINT) {
            returnSet.addAll(this.attachmentConstraints);
            return returnSet;
        }
        if (structureType == SDMX_STRUCTURE_TYPE.CONTENT_CONSTRAINT) {
            returnSet.addAll(this.contentConstraints);
            return returnSet;
        }
        if (structureType == SDMX_STRUCTURE_TYPE.REGISTRATION) {
            returnSet.addAll(this.registrations);
            return returnSet;
        }
        if (structureType == SDMX_STRUCTURE_TYPE.SUBSCRIPTION) {
            returnSet.addAll(this.subscriptions);
            return returnSet;
        }
        throw new SdmxNotImplementedException(ExceptionCode.REFERENCE_ERROR_UNSUPPORTED_QUERY_FOR_STRUCTURE, new Object[]{structureType});
    }

    public void addAgencyScheme(AgencySchemeBean bean) {
        if (bean != null) {
            this.agencySchemes.remove(bean);
            this.agencySchemes.add(bean);
        }
    }

    public void addAttachmentConstraint(AttachmentConstraintBean bean) {
        if (bean != null) {
            this.attachmentConstraints.remove(bean);
            this.attachmentConstraints.add(bean);
        }
    }

    public void addContentConstraintBean(ContentConstraintBean bean) {
        if (bean != null) {
            this.contentConstraints.remove(bean);
            this.contentConstraints.add(bean);
        }
    }

    public void addDataProviderScheme(DataProviderSchemeBean bean) {
        if (bean != null) {
            this.dataProviderSchemes.remove(bean);
            this.dataProviderSchemes.add(bean);
        }
    }

    public void addDataConsumerScheme(DataConsumerSchemeBean bean) {
        if (bean != null) {
            this.dataConsumerSchemes.remove(bean);
            this.dataConsumerSchemes.add(bean);
        }
    }

    public void addOrganisationUnitScheme(OrganisationUnitSchemeBean bean) {
        if (bean != null) {
            this.organisationUnitSchemes.remove(bean);
            this.organisationUnitSchemes.add(bean);
        }
    }

    public void addCategorisation(CategorisationBean bean) {
        if (bean != null) {
            this.categorisation.remove(bean);
            this.categorisation.add(bean);
        }
    }

    public void addCategoryScheme(CategorySchemeBean bean) {
        if (bean != null) {
            this.categorySchemes.remove(bean);
            this.categorySchemes.add(bean);
        }
    }

    public void addCodelist(CodelistBean bean) {
        if (bean != null) {
            this.codelists.remove(bean);
            this.codelists.add(bean);
        }
    }

    public void addConceptScheme(ConceptSchemeBean bean) {
        if (bean != null) {
            this.conceptSchemes.remove(bean);
            this.conceptSchemes.add(bean);
        }
    }

    public void addDataflow(DataflowBean bean) {
        if (bean != null) {
            this.dataflows.remove(bean);
            this.dataflows.add(bean);
        }
    }

    public void addHierarchicalCodelist(HierarchicalCodelistBean bean) {
        if (bean != null) {
            this.hcls.remove(bean);
            this.hcls.add(bean);
        }
    }

    public void addDataStructure(DataStructureBean bean) {
        if (bean != null) {
            this.dataStructures.remove(bean);
            this.dataStructures.add(bean);
        }
    }

    public void addMetadataFlow(MetadataFlowBean bean) {
        if (bean != null) {
            this.metadataflows.remove(bean);
            this.metadataflows.add(bean);
        }
    }

    public void addMetadataStructure(MetadataStructureDefinitionBean bean) {
        if (bean != null) {
            this.metadataStructures.remove(bean);
            this.metadataStructures.add(bean);
        }
    }

    public void addProcess(ProcessBean bean) {
        if (bean != null) {
            this.processes.remove(bean);
            this.processes.add(bean);
        }
    }

    public void addReportingTaxonomy(ReportingTaxonomyBean bean) {
        if (bean != null) {
            this.reportingTaxonomy.remove(bean);
            this.reportingTaxonomy.add(bean);
        }
    }

    public void addStructureSet(StructureSetBean bean) {
        if (bean != null) {
            this.structureSet.remove(bean);
            this.structureSet.add(bean);
        }
    }

    public void addProvisionAgreement(ProvisionAgreementBean bean) {
        if (bean != null) {
            this.provisionAgreement.remove(bean);
            this.provisionAgreement.add(bean);
        }
    }

    public void addRegistration(RegistrationBean registration) {
        if (registration != null) {
            this.registrations.remove(registration);
            this.registrations.add(registration);
        }
    }

    public void addSubscription(SubscriptionBean subscription) {
        if (subscription != null) {
            this.subscriptions.remove(subscription);
            this.subscriptions.add(subscription);
        }
    }

    public Set<AgencyBean> getAgencies() {
        HashSet<AgencyBean> agencySet = new HashSet<AgencyBean>();
        for (AgencySchemeBean currentAgencyScheme : this.agencySchemes) {
            agencySet.addAll(currentAgencyScheme.getItems());
        }
        return agencySet;
    }

    public boolean hasAttachmentConstraints() {
        return ObjectUtil.validCollection(this.attachmentConstraints);
    }

    public boolean hasAgenciesSchemes() {
        return ObjectUtil.validCollection(this.agencySchemes);
    }

    public boolean hasContentConstraintBeans() {
        return ObjectUtil.validCollection(this.contentConstraints);
    }

    public boolean hasOrganisationUnitSchemes() {
        return ObjectUtil.validCollection(this.organisationUnitSchemes);
    }

    public boolean hasDataConsumerSchemes() {
        return ObjectUtil.validCollection(this.dataConsumerSchemes);
    }

    public boolean hasDataflows() {
        return ObjectUtil.validCollection(this.dataflows);
    }

    public boolean hasDataProviderSchemes() {
        return ObjectUtil.validCollection(this.dataProviderSchemes);
    }

    public boolean hasMetadataflows() {
        return ObjectUtil.validCollection(this.metadataflows);
    }

    public boolean hasCategorySchemes() {
        return ObjectUtil.validCollection(this.categorySchemes);
    }

    public boolean hasCodelists() {
        return ObjectUtil.validCollection(this.codelists);
    }

    public boolean hasHierarchicalCodelists() {
        return ObjectUtil.validCollection(this.hcls);
    }

    public boolean hasCategorisations() {
        return ObjectUtil.validCollection(this.categorisation);
    }

    public boolean hasConceptSchemes() {
        return ObjectUtil.validCollection(this.conceptSchemes);
    }

    public boolean hasMetadataStructures() {
        return ObjectUtil.validCollection(this.metadataStructures);
    }

    public boolean hasDataStructures() {
        return ObjectUtil.validCollection(this.dataStructures);
    }

    public boolean hasReportingTaxonomys() {
        return ObjectUtil.validCollection(this.reportingTaxonomy);
    }

    public boolean hasStructureSets() {
        return ObjectUtil.validCollection(this.structureSet);
    }

    public boolean hasProcesses() {
        return ObjectUtil.validCollection(this.processes);
    }

    public boolean hasProvisionAgreements() {
        return ObjectUtil.validCollection(this.provisionAgreement);
    }

    public Set<AttachmentConstraintBean> getAttachmentConstraints() {
        return new RetrunSetCreator().createReturnSet(this.attachmentConstraints);
    }

    public Set<ContentConstraintBean> getContentConstraintBeans() {
        return new RetrunSetCreator().createReturnSet(this.contentConstraints);
    }

    public Set<AgencySchemeBean> getAgenciesSchemes() {
        return new RetrunSetCreator().createReturnSet(this.agencySchemes);
    }

    public Set<OrganisationUnitSchemeBean> getOrganisationUnitSchemes() {
        return new RetrunSetCreator().createReturnSet(this.organisationUnitSchemes);
    }

    public Set<DataConsumerSchemeBean> getDataConsumerSchemes() {
        return new RetrunSetCreator().createReturnSet(this.dataConsumerSchemes);
    }

    public Set<DataProviderSchemeBean> getDataProviderSchemes() {
        return new RetrunSetCreator().createReturnSet(this.dataProviderSchemes);
    }

    public Set<CategorisationBean> getCategorisations() {
        return new RetrunSetCreator().createReturnSet(this.categorisation);
    }

    public Set<CategorySchemeBean> getCategorySchemes() {
        return new RetrunSetCreator().createReturnSet(this.categorySchemes);
    }

    public Set<CodelistBean> getCodelists() {
        return new RetrunSetCreator().createReturnSet(this.codelists);
    }

    public Set<ConceptSchemeBean> getConceptSchemes() {
        return new RetrunSetCreator().createReturnSet(this.conceptSchemes);
    }

    public Set<DataflowBean> getDataflows() {
        return new RetrunSetCreator().createReturnSet(this.dataflows);
    }

    public Set<HierarchicalCodelistBean> getHierarchicalCodelists() {
        return new RetrunSetCreator().createReturnSet(this.hcls);
    }

    public Set<DataStructureBean> getDataStructures() {
        return new RetrunSetCreator().createReturnSet(this.dataStructures);
    }

    public Set<MetadataFlowBean> getMetadataflows() {
        return new RetrunSetCreator().createReturnSet(this.metadataflows);
    }

    public Set<MetadataStructureDefinitionBean> getMetadataStructures() {
        return new RetrunSetCreator().createReturnSet(this.metadataStructures);
    }

    public Set<ProcessBean> getProcesses() {
        return new RetrunSetCreator().createReturnSet(this.processes);
    }

    public Set<ReportingTaxonomyBean> getReportingTaxonomys() {
        return new RetrunSetCreator().createReturnSet(this.reportingTaxonomy);
    }

    public Set<StructureSetBean> getStructureSets() {
        return new RetrunSetCreator().createReturnSet(this.structureSet);
    }

    public Set<ProvisionAgreementBean> getProvisionAgreements() {
        return new RetrunSetCreator().createReturnSet(this.provisionAgreement);
    }

    public Set<RegistrationBean> getRegistrations() {
        return new RetrunSetCreator().createReturnSet(this.registrations);
    }

    public Set<SubscriptionBean> getSubscriptions() {
        return new RetrunSetCreator().createReturnSet(this.subscriptions);
    }

    public Set<AttachmentConstraintBean> getAttachmentConstraints(String agencyId) {
        return new AgencyFilter().filterSet(agencyId, this.attachmentConstraints);
    }

    public AgencySchemeBean getAgencyScheme(String agencyId) {
        for (AgencySchemeBean acyScheme : this.agencySchemes) {
            if (!acyScheme.getAgencyId().equals(agencyId)) continue;
            return acyScheme;
        }
        return null;
    }

    public Set<ContentConstraintBean> getContentConstraintBeans(String agencyId) {
        return new AgencyFilter().filterSet(agencyId, this.contentConstraints);
    }

    public Set<OrganisationUnitSchemeBean> getOrganisationUnitSchemes(String agencyId) {
        return new AgencyFilter().filterSet(agencyId, this.organisationUnitSchemes);
    }

    public DataConsumerSchemeBean getDataConsumerScheme(String agencyId) {
        for (DataConsumerSchemeBean scheme : this.dataConsumerSchemes) {
            if (!scheme.getAgencyId().equals(agencyId)) continue;
            return scheme;
        }
        return null;
    }

    public Set<DataflowBean> getDataflows(String agencyId) {
        return new AgencyFilter().filterSet(agencyId, this.dataflows);
    }

    public DataProviderSchemeBean getDataProviderScheme(String agencyId) {
        for (DataProviderSchemeBean scheme : this.dataProviderSchemes) {
            if (!scheme.getAgencyId().equals(agencyId)) continue;
            return scheme;
        }
        return null;
    }

    public Set<MetadataFlowBean> getMetadataflows(String agencyId) {
        return new AgencyFilter().filterSet(agencyId, this.metadataflows);
    }

    public Set<CategorySchemeBean> getCategorySchemes(String agencyId) {
        return new AgencyFilter().filterSet(agencyId, this.categorySchemes);
    }

    public Set<CodelistBean> getCodelists(String agencyId) {
        return new AgencyFilter().filterSet(agencyId, this.codelists);
    }

    public Set<HierarchicalCodelistBean> getHierarchicalCodelists(String agencyId) {
        return new AgencyFilter().filterSet(agencyId, this.hcls);
    }

    public Set<CategorisationBean> getCategorisations(String agencyId) {
        return new AgencyFilter().filterSet(agencyId, this.categorisation);
    }

    public Set<ConceptSchemeBean> getConceptSchemes(String agencyId) {
        return new AgencyFilter().filterSet(agencyId, this.conceptSchemes);
    }

    public Set<MetadataStructureDefinitionBean> getMetadataStructures(String agencyId) {
        return new AgencyFilter().filterSet(agencyId, this.metadataStructures);
    }

    public Set<DataStructureBean> getDataStructures(String agencyId) {
        return new AgencyFilter().filterSet(agencyId, this.dataStructures);
    }

    public Set<ReportingTaxonomyBean> getReportingTaxonomys(String agencyId) {
        return new AgencyFilter().filterSet(agencyId, this.reportingTaxonomy);
    }

    public Set<StructureSetBean> getStructureSets(String agencyId) {
        return new AgencyFilter().filterSet(agencyId, this.structureSet);
    }

    public Set<ProcessBean> getProcesses(String agencyId) {
        return new AgencyFilter().filterSet(agencyId, this.processes);
    }

    public Set<ProvisionAgreementBean> getProvisionAgreements(String agencyId) {
        return new AgencyFilter().filterSet(agencyId, this.provisionAgreement);
    }

    public Set<RegistrationBean> getRegistrations(String agencyId) {
        return new AgencyFilter().filterSet(agencyId, this.registrations);
    }

    public Set<SubscriptionBean> getSubscriptions(String agencyId) {
        return new AgencyFilter().filterSet(agencyId, this.subscriptions);
    }

    public Set<AgencyBean> getAgencies(MaintainableRefBean ref) {
        return null;
    }

    public Set<AttachmentConstraintBean> getAttachmentConstraints(MaintainableRefBean ref) {
        return new Filter<AttachmentConstraintBean>(SDMX_STRUCTURE_TYPE.ATTACHMENT_CONSTRAINT).filter(this.attachmentConstraints, ref);
    }

    public Set<AgencySchemeBean> getAgenciesSchemes(MaintainableRefBean ref) {
        return new Filter<AgencySchemeBean>(SDMX_STRUCTURE_TYPE.AGENCY_SCHEME).filter(this.agencySchemes, ref);
    }

    public Set<ContentConstraintBean> getContentConstraintBeans(MaintainableRefBean ref) {
        return new Filter<ContentConstraintBean>(SDMX_STRUCTURE_TYPE.CONTENT_CONSTRAINT).filter(this.contentConstraints, ref);
    }

    public Set<OrganisationUnitSchemeBean> getOrganisationUnitSchemes(MaintainableRefBean ref) {
        return new Filter<OrganisationUnitSchemeBean>(SDMX_STRUCTURE_TYPE.ORGANISATION_UNIT_SCHEME).filter(this.organisationUnitSchemes, ref);
    }

    public Set<DataConsumerSchemeBean> getDataConsumerSchemes(MaintainableRefBean ref) {
        return new Filter<DataConsumerSchemeBean>(SDMX_STRUCTURE_TYPE.DATA_CONSUMER_SCHEME).filter(this.dataConsumerSchemes, ref);
    }

    public Set<DataflowBean> getDataflows(MaintainableRefBean ref) {
        return new Filter<DataflowBean>(SDMX_STRUCTURE_TYPE.DATAFLOW).filter(this.dataflows, ref);
    }

    public Set<DataProviderSchemeBean> getDataProviderSchemes(MaintainableRefBean ref) {
        return new Filter<DataProviderSchemeBean>(SDMX_STRUCTURE_TYPE.DATA_PROVIDER_SCHEME).filter(this.dataProviderSchemes, ref);
    }

    public Set<MetadataFlowBean> getMetadataflows(MaintainableRefBean ref) {
        return new Filter<MetadataFlowBean>(SDMX_STRUCTURE_TYPE.METADATA_FLOW).filter(this.metadataflows, ref);
    }

    public Set<CategorySchemeBean> getCategorySchemes(MaintainableRefBean ref) {
        return new Filter<CategorySchemeBean>(SDMX_STRUCTURE_TYPE.CATEGORY_SCHEME).filter(this.categorySchemes, ref);
    }

    public Set<CodelistBean> getCodelists(MaintainableRefBean ref) {
        return new Filter<CodelistBean>(SDMX_STRUCTURE_TYPE.CODE_LIST).filter(this.codelists, ref);
    }

    public Set<HierarchicalCodelistBean> getHierarchicalCodelists(MaintainableRefBean ref) {
        return new Filter<HierarchicalCodelistBean>(SDMX_STRUCTURE_TYPE.HIERARCHICAL_CODELIST).filter(this.hcls, ref);
    }

    public Set<CategorisationBean> getCategorisations(MaintainableRefBean ref) {
        return new Filter<CategorisationBean>(SDMX_STRUCTURE_TYPE.CATEGORISATION).filter(this.categorisation, ref);
    }

    public Set<ConceptSchemeBean> getConceptSchemes(MaintainableRefBean ref) {
        return new Filter<ConceptSchemeBean>(SDMX_STRUCTURE_TYPE.CONCEPT_SCHEME).filter(this.conceptSchemes, ref);
    }

    public Set<MetadataStructureDefinitionBean> getMetadataStructures(MaintainableRefBean ref) {
        return new Filter<MetadataStructureDefinitionBean>(SDMX_STRUCTURE_TYPE.MSD).filter(this.metadataStructures, ref);
    }

    public Set<DataStructureBean> getDataStructures(MaintainableRefBean ref) {
        return new Filter<DataStructureBean>(SDMX_STRUCTURE_TYPE.DSD).filter(this.dataStructures, ref);
    }

    public Set<ReportingTaxonomyBean> getReportingTaxonomys(MaintainableRefBean ref) {
        return new Filter<ReportingTaxonomyBean>(SDMX_STRUCTURE_TYPE.REPORTING_TAXONOMY).filter(this.reportingTaxonomy, ref);
    }

    public Set<StructureSetBean> getStructureSets(MaintainableRefBean ref) {
        return new Filter<StructureSetBean>(SDMX_STRUCTURE_TYPE.STRUCTURE_SET).filter(this.structureSet, ref);
    }

    public Set<ProcessBean> getProcesses(MaintainableRefBean ref) {
        return new Filter<ProcessBean>(SDMX_STRUCTURE_TYPE.PROCESS).filter(this.processes, ref);
    }

    public Set<ProvisionAgreementBean> getProvisionAgreements(MaintainableRefBean ref) {
        return new Filter<ProvisionAgreementBean>(SDMX_STRUCTURE_TYPE.PROVISION_AGREEMENT).filter(this.provisionAgreement, ref);
    }

    public Set<RegistrationBean> getRegistrations(MaintainableRefBean ref) {
        return new Filter<RegistrationBean>(SDMX_STRUCTURE_TYPE.REGISTRATION).filter(this.registrations, ref);
    }

    public Set<SubscriptionBean> getSubscriptions(MaintainableRefBean ref) {
        return new Filter<SubscriptionBean>(SDMX_STRUCTURE_TYPE.SUBSCRIPTION).filter(this.subscriptions, ref);
    }

    public void removeCategorisation(CategorisationBean bean) {
        this.categorisation.remove(bean);
    }

    public void removeMaintainable(MaintainableBean bean) {
        if (bean instanceof AgencySchemeBean) {
            this.removeAgencyScheme((AgencySchemeBean)bean);
        } else if (bean instanceof AttachmentConstraintBean) {
            this.removeAttachmentConstraintBean((AttachmentConstraintBean)bean);
        } else if (bean instanceof CategorisationBean) {
            this.removeCategorisation((CategorisationBean)bean);
        } else if (bean instanceof ContentConstraintBean) {
            this.removeContentConstraintBean((ContentConstraintBean)bean);
        } else if (bean instanceof DataConsumerSchemeBean) {
            this.removeDataConsumerScheme((DataConsumerSchemeBean)bean);
        } else if (bean instanceof DataProviderSchemeBean) {
            this.removeDataProviderScheme((DataProviderSchemeBean)bean);
        } else if (bean instanceof CategorySchemeBean) {
            this.removeCategoryScheme((CategorySchemeBean)bean);
        } else if (bean instanceof CodelistBean) {
            this.removeCodelist((CodelistBean)bean);
        } else if (bean instanceof ConceptSchemeBean) {
            this.removeConceptScheme((ConceptSchemeBean)bean);
        } else if (bean instanceof DataflowBean) {
            this.removeDataflow((DataflowBean)bean);
        } else if (bean instanceof HierarchicalCodelistBean) {
            this.removeHierarchicalCodelist((HierarchicalCodelistBean)bean);
        } else if (bean instanceof DataStructureBean) {
            this.removeDataStructure((DataStructureBean)bean);
        } else if (bean instanceof MetadataFlowBean) {
            this.removeMetadataFlow((MetadataFlowBean)bean);
        } else if (bean instanceof MetadataStructureDefinitionBean) {
            this.removeMetadataStructure((MetadataStructureDefinitionBean)bean);
        } else if (bean instanceof OrganisationUnitSchemeBean) {
            this.removeOrganisationUnitScheme((OrganisationUnitSchemeBean)bean);
        } else if (bean instanceof StructureSetBean) {
            this.removeStructureSet((StructureSetBean)bean);
        } else if (bean instanceof ProcessBean) {
            this.removeProcess((ProcessBean)bean);
        } else if (bean instanceof ReportingTaxonomyBean) {
            this.removeReportingTaxonomy((ReportingTaxonomyBean)bean);
        } else if (bean instanceof CategorisationBean) {
            this.removeCategorisation((CategorisationBean)bean);
        } else if (bean instanceof ProvisionAgreementBean) {
            this.removeProvisionAgreement((ProvisionAgreementBean)bean);
        } else if (bean instanceof RegistrationBean) {
            this.removeRegistration((RegistrationBean)bean);
        } else if (bean instanceof SubscriptionBean) {
            this.removeSubscription((SubscriptionBean)bean);
        }
    }

    public void removeAttachmentConstraintBean(AttachmentConstraintBean bean) {
        this.attachmentConstraints.remove(bean);
    }

    public void removeContentConstraintBean(ContentConstraintBean bean) {
        this.contentConstraints.remove(bean);
    }

    public void removeAgencyScheme(AgencySchemeBean bean) {
        this.agencySchemes.remove(bean);
    }

    public void removeDataProviderScheme(DataProviderSchemeBean bean) {
        this.dataProviderSchemes.remove(bean);
    }

    public void removeDataConsumerScheme(DataConsumerSchemeBean bean) {
        this.dataConsumerSchemes.remove(bean);
    }

    public void removeOrganisationUnitScheme(OrganisationUnitSchemeBean bean) {
        this.organisationUnitSchemes.remove(bean);
    }

    public void removeCategoryScheme(CategorySchemeBean bean) {
        this.categorySchemes.remove(bean);
    }

    public void removeCodelist(CodelistBean bean) {
        this.codelists.remove(bean);
    }

    public void removeConceptScheme(ConceptSchemeBean bean) {
        this.conceptSchemes.remove(bean);
    }

    public void removeDataflow(DataflowBean bean) {
        this.dataflows.remove(bean);
    }

    public void removeHierarchicalCodelist(HierarchicalCodelistBean bean) {
        this.hcls.remove(bean);
    }

    public void removeDataStructure(DataStructureBean bean) {
        this.dataStructures.remove(bean);
    }

    public void removeMetadataFlow(MetadataFlowBean bean) {
        this.metadataflows.remove(bean);
    }

    public void removeMetadataStructure(MetadataStructureDefinitionBean bean) {
        this.metadataStructures.remove(bean);
    }

    public void removeProcess(ProcessBean bean) {
        this.processes.remove(bean);
    }

    public void removeReportingTaxonomy(ReportingTaxonomyBean bean) {
        this.reportingTaxonomy.remove(bean);
    }

    public void removeStructureSet(StructureSetBean bean) {
        this.structureSet.remove(bean);
    }

    public void removeProvisionAgreement(ProvisionAgreementBean bean) {
        this.provisionAgreement.remove(bean);
    }

    public void removeRegistration(RegistrationBean registration) {
        this.registrations.remove(registration);
    }

    public void removeSubscription(SubscriptionBean subscription) {
        this.subscriptions.remove(subscription);
    }

    private class AgencyFilter<T extends MaintainableBean> {
        private AgencyFilter() {
        }

        private Set<T> filterSet(String agencyId, Set<T> walkSet) {
            TreeSet<MaintainableBean> returnSet = new TreeSet<MaintainableBean>(new MaintainableSortByIdentifiers());
            for (MaintainableBean currentMaint : walkSet) {
                if (!currentMaint.getAgencyId().equals(agencyId)) continue;
                returnSet.add(currentMaint);
            }
            return returnSet;
        }
    }

    private class Filter<T extends MaintainableBean> {
        private SDMX_STRUCTURE_TYPE structureType;

        public Filter(SDMX_STRUCTURE_TYPE structureType) {
            this.structureType = structureType;
        }

        public Set<T> filter(Set<T> input, MaintainableRefBean ref) {
            TreeSet<MaintainableBean> returnSet = new TreeSet<MaintainableBean>(new MaintainableSortByIdentifiers());
            if (ref == null) {
                returnSet.addAll(input);
                return returnSet;
            }
            StructureReferenceBeanImpl sRef = new StructureReferenceBeanImpl(ref, this.structureType);
            for (MaintainableBean currentInput : input) {
                if (!sRef.isMatch(currentInput)) continue;
                returnSet.add(currentInput);
            }
            return returnSet;
        }
    }

    private class RetrunSetCreator<T extends MaintainableBean> {
        private RetrunSetCreator() {
        }

        private Set<T> createReturnSet(Set<T> immutableSet) {
            TreeSet<MaintainableBean> returnSet = new TreeSet<MaintainableBean>(new MaintainableSortByIdentifiers());
            returnSet.addAll(immutableSet);
            return returnSet;
        }
    }
}

