/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.util.beans;

import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.base.TextTypeWrapper;
import org.sdmxsource.util.ObjectUtil;

public class ValidationUtil {
    private static final Pattern idWithInt = Pattern.compile("([A-Z]|[a-z]|\\\\|@|[0-9]|_|\\$|\\-)*");
    private static final Pattern idWithNoInt = Pattern.compile("([A-Z]|[a-z])+([A-Z]|[a-z]|\\\\|@|[0-9]|_|\\$|\\-)*");

    public static void validateTextType(List<TextTypeWrapper> textTypes, String validPatternStr) throws SdmxSemmanticException {
        Pattern validPattern = null;
        if (ObjectUtil.validString(validPatternStr)) {
            validPattern = Pattern.compile(validPatternStr);
        }
        HashSet<String> languages = new HashSet<String>();
        if (textTypes != null) {
            for (TextTypeWrapper currentTextType : textTypes) {
                if (validPattern != null && !validPattern.matcher(currentTextType.getValue()).matches()) {
                    throw new SdmxSemmanticException(currentTextType.getValue() + " invalid with respect to allowed string : " + validPattern);
                }
                if (languages.contains(currentTextType.getLocale())) {
                    throw new SdmxSemmanticException(ExceptionCode.DUPLICATE_LANGUAGE, new Object[]{currentTextType.getLocale()});
                }
                languages.add(currentTextType.getLocale());
            }
        }
    }

    public static String cleanAndValidateId(String id, boolean startWithIntAllowed) throws SdmxSemmanticException {
        String trimedId;
        if (!ObjectUtil.validString(id)) {
            return null;
        }
        Pattern idPattern = startWithIntAllowed ? idWithInt : idWithNoInt;
        if (!idPattern.matcher(trimedId = id.trim()).matches()) {
            if (startWithIntAllowed) {
                throw new SdmxSemmanticException(ExceptionCode.STRUCTURE_INVALID_ID, new Object[]{trimedId});
            }
            throw new SdmxSemmanticException(ExceptionCode.STRUCTURE_INVALID_ID_START_ALPHA, new Object[]{trimedId});
        }
        return trimedId;
    }
}

