/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.ediparser.util;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.sdmxsource.sdmx.api.constants.ATTRIBUTE_ATTACHMENT_LEVEL;
import org.sdmxsource.sdmx.api.constants.DATASET_ACTION;
import org.sdmxsource.sdmx.ediparser.constants.EDI_PREFIX;
import org.sdmxsource.sdmx.ediparser.constants.EDI_TIME_FORMAT;
import org.sdmxsource.sdmx.ediparser.util.EDIUtil;
import org.sdmxsource.util.ObjectUtil;

public class EDIDataWriterUtil {
    public static String parseDataSetIdentifier(String dataSetId) {
        String dataSetInEdiForm = EDIUtil.stringToEDIWithMaxLength(dataSetId, 18);
        return (Object)((Object)EDI_PREFIX.DATA_START) + dataSetInEdiForm + "'";
    }

    public static String parseStatus(DATASET_ACTION action) {
        String status = action == DATASET_ACTION.DELETE ? "6" : "7";
        return (Object)((Object)EDI_PREFIX.DATASET_ACTION) + status + "'";
    }

    public static String parseMissingValue() {
        return (Object)((Object)EDI_PREFIX.DATASET_MISSING_VALUE_SYMBOL) + "-" + "'";
    }

    public static String parsePreperationDate(Date date) {
        EDI_TIME_FORMAT timeFormat = EDI_TIME_FORMAT.MINUTE_FOUR_DIG_YEAR;
        return "DTM+242:" + timeFormat.formatDate(date) + ":" + timeFormat.getEdiValue() + "'";
    }

    public static String parseReportingPeriodDate(Date dateFrom, Date dateTo) {
        if (dateFrom.getTime() != dateTo.getTime()) {
            EDI_TIME_FORMAT timeFormat = EDI_TIME_FORMAT.RANGE_DAILY;
            return "DTM+Z02:" + timeFormat.formatDate(dateFrom) + timeFormat.formatDate(dateTo) + ":" + timeFormat.getEdiValue() + "'";
        }
        if (dateFrom.getHours() == 0 && dateFrom.getMinutes() == 0 && dateFrom.getSeconds() == 0) {
            EDI_TIME_FORMAT timeFormat = EDI_TIME_FORMAT.DAILY_FOUR_DIG_YEAR;
            return "DTM+Z02:" + timeFormat.formatDate(dateFrom) + ":" + timeFormat.getEdiValue() + "'";
        }
        EDI_TIME_FORMAT timeFormat = EDI_TIME_FORMAT.MINUTE_FOUR_DIG_YEAR;
        return "DTM+Z02:" + timeFormat.formatDate(dateFrom) + ":" + timeFormat.getEdiValue() + "'";
    }

    public static String parseDataStructureIdentifier(String kfId) {
        return (Object)((Object)EDI_PREFIX.DSD_REFERENCE) + kfId + "'";
    }

    public static String parseMethodToSendDataSet() {
        return (Object)((Object)EDI_PREFIX.DATASET_SEND_METHOD) + "'";
    }

    public static String parseStartAttributes() {
        return (Object)((Object)EDI_PREFIX.DATASET_FOOTNOTE_SECTION) + "Attributes:10" + "'";
    }

    public static String parseAttributeAttachment(int lastDimensionPosition, String key) {
        if (ObjectUtil.validString((String[])new String[]{key})) {
            return String.valueOf(EDI_PREFIX.DATASET_DATAATTRIBUTE.getPrefix()) + lastDimensionPosition + "+" + key + "'";
        }
        return String.valueOf(EDI_PREFIX.DATASET_DATAATTRIBUTE.getPrefix()) + lastDimensionPosition + "'";
    }

    public static String parseAttributeIdentifier(String conceptId, boolean isCoded) {
        if (isCoded) {
            return (Object)((Object)EDI_PREFIX.DATASET_ATTRIBUTE_CODED) + conceptId + "'";
        }
        return (Object)((Object)EDI_PREFIX.DATASET_ATTRIBUTE_UNCODED) + conceptId + "'";
    }

    public static List<String> parseAttributeValue(String value, boolean isCode) {
        if (isCode) {
            String codeValue = String.valueOf(EDI_PREFIX.CODE_VALUE.getPrefix()) + EDIUtil.stringToEdi(value) + "'";
            return Collections.singletonList(codeValue);
        }
        return EDIUtil.stringToEDIFreeText(value, 70, 350, 20);
    }

    public static String parseAttributeScope(ATTRIBUTE_ATTACHMENT_LEVEL attachment) {
        String scope;
        switch (attachment) {
            case DATA_SET: {
                scope = "1";
                break;
            }
            case OBSERVATION: {
                scope = "5";
                break;
            }
            default: {
                scope = "4";
            }
        }
        return (Object)((Object)EDI_PREFIX.DATASET_ATTRIBUTE_SCOPE) + scope + "'";
    }
}

