/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.ediparser.model.reader.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.sdmxsource.sdmx.api.util.ReadableDataLocation;
import org.sdmxsource.sdmx.ediparser.model.reader.FileReader;
import org.sdmxsource.util.io.StreamUtil;

public class FileReaderImpl
implements FileReader {
    protected ReadableDataLocation dataFile;
    private String endOfLineTag;
    private BufferedReader bufferedReader;
    protected String currentLine;
    protected boolean backLine;
    protected int filePosition;
    private int startIndex = -1;
    private int endIndex = -1;
    private String charset;

    public FileReaderImpl(ReadableDataLocation dataFile, String endOfLineTag) {
        this.dataFile = dataFile;
        this.endOfLineTag = endOfLineTag;
        this.resetReader();
    }

    public FileReaderImpl(ReadableDataLocation dataFile, String endOfLineTag, String charset) {
        this.dataFile = dataFile;
        this.endOfLineTag = endOfLineTag;
        this.charset = charset;
        this.resetReader();
    }

    public FileReaderImpl(ReadableDataLocation dataFile, String endOfLineTag, int startindex, int endIndex) {
        this.dataFile = dataFile;
        this.endOfLineTag = endOfLineTag;
        this.startIndex = startindex;
        this.endIndex = endIndex;
        this.resetReader();
    }

    public FileReaderImpl(ReadableDataLocation dataFile, String endOfLineTag, int startindex, int endIndex, String charset) {
        this.dataFile = dataFile;
        this.endOfLineTag = endOfLineTag;
        this.startIndex = startindex;
        this.endIndex = endIndex;
        this.charset = charset;
        this.resetReader();
    }

    @Override
    public void resetReader() {
        if (this.bufferedReader != null) {
            try {
                this.bufferedReader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.bufferedReader = this.charset != null ? new BufferedReader(new InputStreamReader(this.dataFile.getInputStream(), Charset.forName(this.charset))) : new BufferedReader(new InputStreamReader(this.dataFile.getInputStream()));
        this.filePosition = 0;
        if (this.startIndex > 0) {
            while (this.filePosition != this.startIndex) {
                this.moveNext();
            }
        }
    }

    @Override
    public boolean moveNext() {
        if (this.filePosition == this.endIndex) {
            this.currentLine = null;
            return false;
        }
        StringBuilder sb = new StringBuilder();
        boolean hasNext = false;
        int currentChar = -1;
        int previousChar = -1;
        int prevQuestionMarkCount = 0;
        try {
            while (true) {
                prevQuestionMarkCount = (previousChar = currentChar) == 63 ? ++prevQuestionMarkCount : 0;
                currentChar = this.bufferedReader.read();
                if (currentChar != -1 && (currentChar != 39 || previousChar == 63 && prevQuestionMarkCount % 2 != 0)) {
                    hasNext = true;
                    sb.append((char)currentChar);
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {}
        if (hasNext) {
            ++this.filePosition;
            this.currentLine = sb.toString();
        } else {
            this.currentLine = null;
        }
        this.cleanLine();
        return this.currentLine != null && this.currentLine.length() > 0;
    }

    @Override
    public String getNextLine() {
        if (this.backLine) {
            this.backLine = false;
            return this.currentLine;
        }
        if (this.moveNext()) {
            return this.getCurrentLine();
        }
        return null;
    }

    @Override
    public boolean isBackLine() {
        return this.backLine;
    }

    @Override
    public String getCurrentLine() {
        return this.currentLine;
    }

    private void cleanLine() {
        if (this.currentLine != null) {
            this.currentLine = this.currentLine.replaceAll("\\u000A", "");
            this.currentLine = this.currentLine.replaceAll("\\u000D", "");
        }
    }

    @Override
    public int getLineNumber() {
        return this.filePosition;
    }

    @Override
    public void moveBackLine() {
        this.backLine = true;
    }

    @Override
    public void copyToStream(OutputStream out) {
        StreamUtil.copyStream((InputStream)this.dataFile.getInputStream(), (OutputStream)out);
    }

    @Override
    public void close() {
        try {
            this.bufferedReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

