/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.ediparser.model.document.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.sdmxsource.sdmx.api.constants.DATASET_ACTION;
import org.sdmxsource.sdmx.api.model.data.KeyValue;
import org.sdmxsource.sdmx.api.model.header.PartyBean;
import org.sdmxsource.sdmx.ediparser.model.document.EDIDocumentPosition;

public class EDIDocumentPositionImpl
implements EDIDocumentPosition {
    private int startLine;
    private int endLine;
    private boolean isStructure;
    private Date datasetPreparation;
    private Date reportingPeriod;
    private String datasetId;
    private String messageAgency;
    private PartyBean sendingAgency;
    private String recievingAgency;
    private DATASET_ACTION datasetAction;
    private String keyFamilyIdentifier;
    private String missingValue;
    private List<KeyValue> datasetAttributes;

    public EDIDocumentPositionImpl(int startLine, int endLine, boolean isStructure, String datasetId, String messageAgency, PartyBean sendingAgency, String recievingAgency, DATASET_ACTION datasetAction, String keyFamilyIdentifier, String missingValue, Date datasetPreparation, Date reportingPeriod, List<KeyValue> datasetAttributes) {
        this.startLine = startLine;
        this.endLine = endLine;
        this.isStructure = isStructure;
        this.datasetId = datasetId;
        this.messageAgency = messageAgency;
        this.sendingAgency = sendingAgency;
        this.recievingAgency = recievingAgency;
        this.datasetAction = datasetAction;
        this.keyFamilyIdentifier = keyFamilyIdentifier;
        this.missingValue = missingValue;
        this.datasetPreparation = datasetPreparation;
        this.reportingPeriod = reportingPeriod;
        this.datasetAttributes = datasetAttributes;
    }

    @Override
    public List<KeyValue> getDatasetAttributes() {
        return new ArrayList<KeyValue>(this.datasetAttributes);
    }

    @Override
    public Date getPreparationDate() {
        return this.datasetPreparation;
    }

    @Override
    public Date getReportingPeriod() {
        return this.reportingPeriod;
    }

    @Override
    public DATASET_ACTION getDatasetAction() {
        return this.datasetAction;
    }

    @Override
    public String getDatasetId() {
        return this.datasetId;
    }

    @Override
    public String getDataStructureIdentifier() {
        return this.keyFamilyIdentifier;
    }

    @Override
    public String getMissingValue() {
        return this.missingValue;
    }

    @Override
    public String getMessageAgency() {
        return this.messageAgency;
    }

    @Override
    public PartyBean getSendingAgency() {
        return this.sendingAgency;
    }

    @Override
    public String getRecievingAgency() {
        return this.recievingAgency;
    }

    @Override
    public boolean isStructure() {
        return this.isStructure;
    }

    @Override
    public boolean isData() {
        return !this.isStructure;
    }

    @Override
    public int getStartLine() {
        return this.startLine;
    }

    @Override
    public int getEndLine() {
        return this.endLine;
    }
}

