/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.ediparser.factory;

import org.apache.log4j.Logger;
import org.sdmxsource.sdmx.api.constants.SDMX_SCHEMA;
import org.sdmxsource.sdmx.api.factory.StructureParserFactory;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.util.ReadableDataLocation;
import org.sdmxsource.sdmx.ediparser.manager.EdiParseManager;
import org.sdmxsource.sdmx.ediparser.model.EDIWorkspace;
import org.sdmxsource.sdmx.util.beans.container.SdmxBeansImpl;
import org.sdmxsource.sdmx.util.sdmx.SdmxMessageUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EdiStructureParserFactory
implements StructureParserFactory {
    private static final Logger LOG = Logger.getLogger(EdiStructureParserFactory.class);
    @Autowired
    private EdiParseManager ediParseManager;

    public SdmxBeans getSdmxBeans(ReadableDataLocation dataLocation) {
        SDMX_SCHEMA schemaVersion = null;
        try {
            schemaVersion = SdmxMessageUtil.getSchemaVersion((ReadableDataLocation)dataLocation);
        }
        catch (Throwable throwable) {
            return null;
        }
        if (schemaVersion != SDMX_SCHEMA.EDI) {
            return null;
        }
        LOG.info((Object)"Parse EDI Message");
        EDIWorkspace ediWorkspace = this.ediParseManager.parseEDIMessage(dataLocation);
        if (ediWorkspace.hasStructures()) {
            return ediWorkspace.getMergedBeans();
        }
        return new SdmxBeansImpl();
    }
}

