/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.ediparser.engine.writer.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.sdmxsource.sdmx.api.constants.ATTRIBUTE_ATTACHMENT_LEVEL;
import org.sdmxsource.sdmx.api.constants.DATASET_ACTION;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.constants.TIME_FORMAT;
import org.sdmxsource.sdmx.api.engine.DataWriterEngine;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.exception.SdmxNotImplementedException;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.factory.WriteableDataLocationFactory;
import org.sdmxsource.sdmx.api.model.beans.base.AnnotationBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.AttributeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataflowBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DimensionBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ProvisionAgreementBean;
import org.sdmxsource.sdmx.api.model.header.DatasetHeaderBean;
import org.sdmxsource.sdmx.api.model.header.DatasetStructureReferenceBean;
import org.sdmxsource.sdmx.api.model.header.HeaderBean;
import org.sdmxsource.sdmx.api.model.header.PartyBean;
import org.sdmxsource.sdmx.api.util.WriteableDataLocation;
import org.sdmxsource.sdmx.ediparser.constants.EDI_PREFIX;
import org.sdmxsource.sdmx.ediparser.constants.EDI_TIME_FORMAT;
import org.sdmxsource.sdmx.ediparser.constants.MESSSAGE_FUNCTION;
import org.sdmxsource.sdmx.ediparser.engine.writer.EDIDataWriterEngine;
import org.sdmxsource.sdmx.ediparser.model.impl.InterchangeHeader;
import org.sdmxsource.sdmx.ediparser.model.impl.MessageIdentification;
import org.sdmxsource.sdmx.ediparser.util.EDIDataWriterUtil;
import org.sdmxsource.sdmx.ediparser.util.EDIUtil;
import org.sdmxsource.sdmx.sdmxbeans.model.header.DatasetHeaderBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.header.DatasetStructureReferenceBeanImpl;
import org.sdmxsource.sdmx.util.date.DateUtil;
import org.sdmxsource.util.ObjectUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.beans.factory.aspectj.AbstractDependencyInjectionAspect;
import org.springframework.beans.factory.aspectj.AnnotationBeanConfigurerAspect;
import org.springframework.beans.factory.aspectj.ConfigurableObject;

@Configurable
public class EDIDataWriterEngineImpl
implements EDIDataWriterEngine,
ConfigurableObject {
    private static final Logger LOG;
    @Autowired
    private WriteableDataLocationFactory writeableDataLocationFactory;
    private String obsConf;
    private String obsPreBreak;
    private static int DATASET_ID;
    private OutputStreamWriter writer;
    private DataStructureBean dsd;
    private HeaderBean headerBean;
    private int numLines;
    private int numMessages;
    private InterchangeHeader header;
    private MessageIdentification messageId;
    private WriteableDataLocation tmpAttributeFileDataset;
    private WriteableDataLocation tmpAttributeFileSeries;
    private WriteableDataLocation tmpAttributeFileObs;
    private OutputStreamWriter datasetAttributeWriter;
    private OutputStreamWriter seriesAttributeWriter;
    private OutputStreamWriter obsAttributeWriter;
    private String currentSeriesKey;
    private String currentAttributeKey;
    private Date currentObsStartDate;
    private Date currentObsEndDate;
    private Map<AttributeBean, AttributeKeyCreator> seriesAttributeKeyCreator;
    private Map<String, Date> dateMap;
    private Map<String, TIME_FORMAT> timeFormatMap;
    private Map<String, String> dateValues;
    private Map<TIME_FORMAT, DateIterations> dateIterationsMap;
    private String currentObsTime;
    private String currentObsValue;
    private String currentObsStatus;
    private String currentObsConf;
    private String currentObsPreBreak;
    private static final int MAX_MISSING = 3;
    private boolean hasAttributes;
    private boolean hasFootnoteSection;
    private TIME_FORMAT timeFormat;
    private Date currentObsDate;
    private Map<String, String> keyValues;
    private List<String> dimensionIds;
    private POSITION currentPOS;
    private boolean headerWritten;
    private DatasetHeaderBean currentDatasetHeader;
    private int messageRefCounter;
    private boolean readerClosed;
    private Map<String, String> bufferedAttributes;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        EDIDataWriterEngineImpl.ajc$preClinit();
        LOG = Logger.getLogger(EDIDataWriterEngineImpl.class);
        DATASET_ID = 1;
    }

    public EDIDataWriterEngineImpl(OutputStream out) {
        OutputStream outputStream = out;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)outputStream);
        JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        if (this != null && this.getClass().isAnnotationPresent(Configurable.class) && AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)this.getClass().getAnnotation(Configurable.class))) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$before$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$1$e854fa65((Object)this);
        }
        if (this != null && this.getClass().isAnnotationPresent(Configurable.class) && (this == null || !this.getClass().isAnnotationPresent(Configurable.class) || !AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)this.getClass().getAnnotation(Configurable.class))) && AbstractDependencyInjectionAspect.ajc$if$6f1((JoinPoint)joinPoint2)) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c((Object)this);
        }
        this.obsConf = "OBS_CONF";
        this.obsPreBreak = "OBS_PRE_BREAK";
        this.currentSeriesKey = "";
        this.currentAttributeKey = null;
        this.seriesAttributeKeyCreator = new HashMap<AttributeBean, AttributeKeyCreator>();
        this.dateMap = new HashMap<String, Date>();
        this.timeFormatMap = new HashMap<String, TIME_FORMAT>();
        this.dateValues = new HashMap<String, String>();
        this.dateIterationsMap = new HashMap<TIME_FORMAT, DateIterations>();
        this.currentObsValue = "-";
        this.currentObsStatus = "";
        this.currentObsConf = "";
        this.currentObsPreBreak = "";
        this.keyValues = new HashMap<String, String>();
        this.dimensionIds = new ArrayList<String>();
        this.currentPOS = POSITION.DATASET;
        this.headerWritten = false;
        this.bufferedAttributes = new TreeMap<String, String>();
        ++DATASET_ID;
        this.writer = this.createOutputStreamWriter(out);
        this.messageRefCounter = 1;
        if (!AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)this.getClass().getAnnotation(Configurable.class)) && AbstractDependencyInjectionAspect.ajc$if$6f1((JoinPoint)joinPoint)) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c((Object)this);
        }
    }

    private OutputStreamWriter createOutputStreamWriter(OutputStream os) {
        try {
            OutputStreamWriter osw = new OutputStreamWriter(os, "ISO-8859-1");
            return osw;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported charset encoding!", e);
        }
    }

    private OutputStreamWriter getAttributeWriter() {
        switch (this.currentPOS) {
            case DATASET: {
                if (this.datasetAttributeWriter == null) {
                    this.tmpAttributeFileDataset = this.writeableDataLocationFactory.getTemporaryWriteableDataLocation();
                    this.datasetAttributeWriter = this.createOutputStreamWriter(this.tmpAttributeFileDataset.getOutputStream());
                    this.write(this.datasetAttributeWriter, EDIDataWriterUtil.parseAttributeScope(ATTRIBUTE_ATTACHMENT_LEVEL.DATA_SET));
                    this.writeLineSeparator(this.datasetAttributeWriter);
                }
                return this.datasetAttributeWriter;
            }
            case OBS: {
                if (this.obsAttributeWriter == null) {
                    this.tmpAttributeFileObs = this.writeableDataLocationFactory.getTemporaryWriteableDataLocation();
                    this.obsAttributeWriter = this.createOutputStreamWriter(this.tmpAttributeFileObs.getOutputStream());
                    this.write(this.obsAttributeWriter, EDIDataWriterUtil.parseAttributeScope(ATTRIBUTE_ATTACHMENT_LEVEL.OBSERVATION));
                    this.writeLineSeparator(this.obsAttributeWriter);
                }
                return this.obsAttributeWriter;
            }
        }
        if (this.seriesAttributeWriter == null) {
            this.tmpAttributeFileSeries = this.writeableDataLocationFactory.getTemporaryWriteableDataLocation();
            this.seriesAttributeWriter = this.createOutputStreamWriter(this.tmpAttributeFileSeries.getOutputStream());
            this.write(this.seriesAttributeWriter, EDIDataWriterUtil.parseAttributeScope(ATTRIBUTE_ATTACHMENT_LEVEL.GROUP));
            this.writeLineSeparator(this.seriesAttributeWriter);
        }
        return this.seriesAttributeWriter;
    }

    public void writeHeader(HeaderBean header) {
        if (this.headerWritten) {
            throw new SdmxException("Can not write header as message has already been started");
        }
        this.headerBean = header;
    }

    private void startMessage() {
        if (!this.headerWritten) {
            this.headerWritten = true;
            String senderId = "undefined";
            String receiverId = "undefined";
            Date preparedDate = new Date();
            String iref = null;
            if (this.headerBean != null) {
                if (this.headerBean.getId() != null) {
                    iref = this.headerBean.getId();
                }
                if (this.headerBean.getSender() != null) {
                    senderId = this.headerBean.getSender().getId();
                }
                if (this.headerBean.getReceiver().size() > 0) {
                    receiverId = ((PartyBean)this.headerBean.getReceiver().get(0)).getId();
                }
                if (this.headerBean.getPrepared() != null) {
                    preparedDate = this.headerBean.getPrepared();
                }
            }
            InterchangeHeader header = iref == null ? new InterchangeHeader(senderId, receiverId, preparedDate, DATASET_ID, null) : new InterchangeHeader(senderId, receiverId, preparedDate, iref, DATASET_ID, null);
            this.writeInterchangeAdministration(header);
        }
    }

    public void startDataset(ProvisionAgreementBean prov, DataflowBean flow, DataStructureBean dsd, DatasetHeaderBean datasetHeader, AnnotationBean ... annotations) {
        this.flushCurrentDataset();
        if (dsd == null) {
            throw new IllegalArgumentException("Can not start EDI dataset, data structure definition not provided");
        }
        if (!this.headerWritten) {
            this.startMessage();
        }
        this.currentPOS = POSITION.DATASET;
        this.currentDatasetHeader = datasetHeader;
        if (this.currentDatasetHeader == null) {
            this.currentDatasetHeader = new DatasetHeaderBeanImpl(dsd.getId(), DATASET_ACTION.APPEND, (DatasetStructureReferenceBean)new DatasetStructureReferenceBeanImpl(dsd.asReference()));
        }
        this.dsd = dsd;
        this.dimensionIds = new ArrayList<String>();
        this.seriesAttributeKeyCreator = new HashMap<AttributeBean, AttributeKeyCreator>();
        for (DimensionBean currentDim : dsd.getDimensions(new SDMX_STRUCTURE_TYPE[]{SDMX_STRUCTURE_TYPE.DIMENSION})) {
            this.dimensionIds.add(currentDim.getId());
        }
        for (AttributeBean attribute : dsd.getSeriesAttributes(null)) {
            this.seriesAttributeKeyCreator.put(attribute, new AttributeKeyCreator(attribute));
        }
        if (dsd.getAttribute("OBS_CONF") == null && dsd.getAttribute("CONF_STATUS") != null) {
            this.obsConf = "CONF_STATUS";
        }
        if (dsd.getAttribute("OBS_PRE_BREAK") == null && dsd.getAttribute("PRE_BREAK_VALUE") != null) {
            this.obsPreBreak = "PRE_BREAK_VALUE";
        }
        ++DATASET_ID;
        MessageIdentification identification = new MessageIdentification(this.messageRefCounter);
        ++this.messageRefCounter;
        this.writeMessageIdentification(identification);
        this.writeMessageFunction(MESSSAGE_FUNCTION.STATISTICAL_DATA);
        this.writeStructureMaintAgency(dsd.getAgencyId());
        String sender = "undefined";
        String receiver = "undefined";
        String datasetId = this.currentDatasetHeader.getDatasetId();
        String reportingPeriod = null;
        if (this.headerBean != null) {
            if (this.headerBean.getSender() != null) {
                sender = this.headerBean.getSender().getId();
            }
            if (ObjectUtil.validCollection((Collection)this.headerBean.getReceiver())) {
                receiver = ((PartyBean)this.headerBean.getReceiver().get(0)).getId();
            }
            if (datasetId == null && ObjectUtil.validString((String[])new String[]{this.headerBean.getDatasetId()})) {
                datasetId = this.headerBean.getDatasetId();
            }
            if (datasetId == null && ObjectUtil.validString((String[])new String[]{this.headerBean.getId()})) {
                datasetId = this.headerBean.getId();
            }
            if (this.currentDatasetHeader.getReportingBeginDate() != null && this.currentDatasetHeader.getReportingEndDate() != null) {
                reportingPeriod = EDIDataWriterUtil.parseReportingPeriodDate(this.currentDatasetHeader.getReportingBeginDate(), this.currentDatasetHeader.getReportingEndDate());
            } else if (this.headerBean.getReportingBegin() != null && this.headerBean.getReportingEnd() != null) {
                reportingPeriod = EDIDataWriterUtil.parseReportingPeriodDate(this.headerBean.getReportingBegin(), this.headerBean.getReportingEnd());
            }
        }
        this.writeRecievingAgency(receiver);
        this.writeSendingAgency(sender);
        this.writeSegment(EDIDataWriterUtil.parseDataSetIdentifier(datasetId));
        this.writeSegment(EDIDataWriterUtil.parseStatus(this.currentDatasetHeader.getAction()));
        if (this.headerBean != null && this.headerBean.getPrepared() != null) {
            this.writeSegment(EDIDataWriterUtil.parsePreperationDate(this.headerBean.getPrepared()));
        } else {
            this.writeSegment(EDIDataWriterUtil.parsePreperationDate(new Date()));
        }
        if (reportingPeriod != null) {
            this.writeSegment(reportingPeriod);
        }
        this.writeSegment(EDIDataWriterUtil.parseDataStructureIdentifier(dsd.getId()));
        this.writeSegment(EDIDataWriterUtil.parseMethodToSendDataSet());
        this.writeSegment(EDIDataWriterUtil.parseMissingValue());
    }

    public void setCrossSectionConcept(String concept) throws SdmxNotImplementedException {
        if (concept != null && !concept.equals("TIME_PERIOD")) {
            throw new SdmxNotImplementedException("Cross sectional datasets are not supported for EDI data");
        }
    }

    public void startGroup(String groupId, AnnotationBean ... annotations) {
        this.startMessage();
        this.flushDataLine();
        this.currentPOS = POSITION.GROUP;
        this.currentSeriesKey = "";
        this.keyValues.clear();
    }

    public void writeGroupKeyValue(String conceptId, String conceptValue) {
        if (this.currentPOS != POSITION.GROUP) {
            throw new SdmxException("Can not write group key value, a call to the method startGroup(..) must first be made");
        }
        this.keyValues.put(conceptId, conceptValue);
    }

    public void startSeries(AnnotationBean ... annotations) {
        this.startMessage();
        this.flushDataLine();
        this.currentPOS = POSITION.SERIES;
        this.currentSeriesKey = "";
        this.keyValues.clear();
    }

    public void writeSeriesKeyValue(String conceptId, String conceptValue) {
        if (this.currentPOS != POSITION.SERIES) {
            this.startSeries(new AnnotationBean[0]);
        }
        if (!this.dimensionIds.contains(conceptId)) {
            throw new SdmxException("Data Structure '" + this.dsd.getId() + "' does not contain dimension with id '" + conceptId + "'");
        }
        this.keyValues.put(conceptId, conceptValue);
    }

    private void createSeriesKey() {
        if (this.currentSeriesKey.length() == 0 && this.keyValues.size() > 0) {
            String concat = "";
            for (String currentDimension : this.dimensionIds) {
                String val = this.keyValues.get(currentDimension);
                this.currentSeriesKey = String.valueOf(this.currentSeriesKey) + concat;
                if (val != null) {
                    this.currentSeriesKey = String.valueOf(this.currentSeriesKey) + val;
                }
                concat = ":";
            }
        }
    }

    private void flushAttributes() {
        this.hasAttributes = false;
        for (String key : this.bufferedAttributes.keySet()) {
            this.flushAttributeValue(key, this.bufferedAttributes.get(key));
        }
        this.bufferedAttributes.clear();
    }

    public void writeAttributeValue(String attributeId, String conceptValue) {
        this.bufferedAttributes.put(attributeId, conceptValue);
    }

    private void flushAttributeValue(String attributeId, String conceptValue) {
        boolean writeAttr;
        if (conceptValue == null) {
            conceptValue = "";
        }
        this.startMessage();
        if (this.currentPOS == POSITION.OBS) {
            if (attributeId.equals("OBS_STATUS")) {
                this.currentObsStatus = conceptValue;
                return;
            }
            if (attributeId.equals(this.obsConf)) {
                this.currentObsConf = conceptValue;
                return;
            }
            if (attributeId.equals(this.obsPreBreak)) {
                this.currentObsPreBreak = conceptValue == null || conceptValue.equals("NaN") ? "-" : conceptValue;
                return;
            }
        }
        this.hasAttributes = true;
        this.hasFootnoteSection = true;
        if ("TIME_FORMAT".equals(attributeId)) {
            return;
        }
        AttributeBean attribute = this.dsd.getAttribute(attributeId);
        if (attribute == null) {
            throw new SdmxException("Data Structure '" + this.dsd.getId() + "' does not contain an attribute with identifier: " + attributeId);
        }
        switch (attribute.getAttachmentLevel()) {
            case DATA_SET: {
                if (this.currentPOS == POSITION.DATASET) break;
                throw new SdmxException("Can not write a dataset attribute '" + attributeId + "' when currently processing output for " + (Object)((Object)this.currentPOS));
            }
            case DIMENSION_GROUP: {
                if (this.currentPOS == POSITION.SERIES) break;
                throw new SdmxException("Can not write a series attribute '" + attributeId + "' when currently processing output for " + (Object)((Object)this.currentPOS));
            }
            case GROUP: {
                if (this.currentPOS == POSITION.GROUP) break;
                throw new SdmxException("Can not write a group attribute '" + attributeId + "' when currently processing output for " + (Object)((Object)this.currentPOS));
            }
            case OBSERVATION: {
                if (this.currentPOS == POSITION.OBS) break;
                throw new SdmxException("Can not write a observation attribute '" + attributeId + "' when currently processing output for " + (Object)((Object)this.currentPOS));
            }
        }
        boolean isCoded = attribute.hasCodedRepresentation();
        this.createSeriesKey();
        String outputKey = this.currentSeriesKey;
        int keyLength = this.dimensionIds.size();
        if (attribute.getAttachmentLevel() == ATTRIBUTE_ATTACHMENT_LEVEL.DIMENSION_GROUP) {
            outputKey = this.seriesAttributeKeyCreator.get(attribute).createSubKey();
        } else if (attribute.getAttachmentLevel() == ATTRIBUTE_ATTACHMENT_LEVEL.DATA_SET) {
            keyLength = 0;
            outputKey = "";
        } else if (this.currentPOS == POSITION.OBS) {
            EDI_TIME_FORMAT ediTimeFormat = EDI_TIME_FORMAT.parseTimeFormat(this.timeFormat, false);
            String ediObsTime = ediTimeFormat.formatDate(this.currentObsDate);
            outputKey = String.valueOf(outputKey) + ":" + ediObsTime + ":" + EDI_TIME_FORMAT.parseTimeFormat(this.timeFormat, false).getEdiValue();
            keyLength += 2;
        }
        OutputStreamWriter osw = this.getAttributeWriter();
        if (this.currentAttributeKey == null || !outputKey.equals(this.currentAttributeKey)) {
            this.write(osw, EDIDataWriterUtil.parseAttributeAttachment(keyLength, outputKey));
            this.writeLineSeparator(osw);
            this.currentAttributeKey = outputKey;
        }
        if (writeAttr = this.currentDatasetHeader.getAction() == DATASET_ACTION.DELETE ? true : conceptValue.length() > 0) {
            this.write(osw, EDIDataWriterUtil.parseAttributeIdentifier(attributeId, isCoded));
            this.writeLineSeparator(osw);
            List<String> values = EDIDataWriterUtil.parseAttributeValue(conceptValue, isCoded);
            for (String val : values) {
                this.write(osw, val);
                this.writeLineSeparator(osw);
            }
        }
    }

    public void writeObservation(String obsConceptValue, String obsValue, AnnotationBean ... annotations) {
        this.writeObservation("TIME_PERIOD", obsConceptValue, obsValue, annotations);
    }

    public void writeObservation(String observationConceptId, String obsTime, String obsValue, AnnotationBean ... annotations) {
        if (observationConceptId == null) {
            observationConceptId = "TIME_PERIOD";
        }
        if (!observationConceptId.equals("TIME_PERIOD")) {
            throw new IllegalArgumentException("SDMX_EDI only supported time Series data, the observation conceptId is expected to be TIME_PERIOD, but got:" + observationConceptId);
        }
        this.flushObs();
        if (obsValue == null || obsValue.equals("NaN")) {
            obsValue = "-";
        }
        if (obsValue.contains("E") && obsValue.contains("+")) {
            obsValue = obsValue.replaceAll("\\+", "");
        }
        if (obsValue.length() > 15) {
            if (EDIUtil.isTruncateLongValues()) {
                String originalValue = obsValue;
                obsValue = EDIUtil.truncate(obsValue);
                LOG.warn((Object)("Truncating EDI Observation value. Original value: " + originalValue + " truncated to: " + obsValue));
            } else {
                throw new SdmxSemmanticException("Illegal Observation value! Maximum length for an EDI observation is 15 characters. Supplied observation: " + obsValue);
            }
        }
        this.currentPOS = POSITION.OBS;
        this.currentObsDate = this.dateMap.get(obsTime);
        if (this.currentObsDate == null) {
            if (obsTime.contains("-B")) {
                obsTime = obsTime.replaceAll("-B", "-S");
            }
            this.currentObsDate = DateUtil.formatDate((Object)obsTime, (boolean)false);
            this.dateMap.put(obsTime, this.currentObsDate);
        }
        this.timeFormat = this.timeFormatMap.get(obsTime);
        if (this.timeFormat == null) {
            this.timeFormat = DateUtil.getTimeFormatOfDate((String)obsTime);
            this.timeFormatMap.put(obsTime, this.timeFormat);
            this.dateIterationsMap.put(this.timeFormat, new DateIterations(this.timeFormat));
        }
        this.currentObsTime = obsTime;
        this.currentObsValue = obsValue;
    }

    private void storeReportedDate() {
        if (this.currentObsStartDate == null || this.currentObsDate.getTime() < this.currentObsStartDate.getTime()) {
            this.currentObsStartDate = this.currentObsDate;
        }
        if (this.currentObsEndDate == null || this.currentObsDate.getTime() > this.currentObsEndDate.getTime()) {
            this.currentObsEndDate = this.currentObsDate;
        }
    }

    private void flushObs() {
        this.flushAttributes();
        if (this.currentObsTime != null) {
            this.createObsValue();
            if (this.timeFormat == TIME_FORMAT.DATE_TIME || this.timeFormat == TIME_FORMAT.HOUR) {
                this.createSeriesKey();
                EDI_TIME_FORMAT ediTimeFormat = EDI_TIME_FORMAT.parseTimeFormat(this.timeFormat, false);
                this.outputObs(ediTimeFormat.formatDate(this.currentObsDate), ediTimeFormat.getEdiValue(), this.currentObsValue);
            } else {
                String existingValue = this.dateValues.get(this.currentObsTime);
                if (ObjectUtil.validString((String[])new String[]{existingValue})) {
                    int colonPos = existingValue.indexOf(":");
                    String actualValue = colonPos == -1 ? existingValue : existingValue.substring(0, colonPos);
                    String string = Arrays.toString(this.keyValues.entrySet().toArray());
                    LOG.warn((Object)("Warning: For the dataset: " + this.dsd + " within the Series: " + string));
                    LOG.warn((Object)("  There is an existing value for the time period: " + this.currentObsTime + " and this value will be overwritten. Existing value: " + actualValue));
                }
                if (this.currentObsTime.contains("-B")) {
                    this.currentObsTime = this.currentObsTime.replaceAll("-B", "-S");
                }
                this.dateValues.put(this.currentObsTime, this.currentObsValue);
                this.storeReportedDate();
            }
        }
        this.currentObsValue = "-";
        this.currentObsStatus = "";
        this.currentObsConf = "";
        this.currentObsPreBreak = "";
    }

    public void writeObservation(Date obsTime, String obsValue, TIME_FORMAT sdmxTimeFormat, AnnotationBean ... annotations) {
        this.writeObservation("TIME_PERIOD", DateUtil.formatDate((Date)obsTime, (TIME_FORMAT)sdmxTimeFormat), obsValue, new AnnotationBean[0]);
    }

    private void createObsValue() {
        if (this.currentDatasetHeader.getAction() == DATASET_ACTION.DELETE) {
            this.currentObsValue = "";
        }
        if (this.currentObsTime != null) {
            if (this.currentObsPreBreak.length() > 0) {
                this.currentObsValue = String.valueOf(this.currentObsValue) + ":" + this.currentObsStatus + ":" + this.currentObsConf + ":" + this.currentObsPreBreak;
            } else if (this.currentObsConf.length() > 0) {
                this.currentObsValue = String.valueOf(this.currentObsValue) + ":" + this.currentObsStatus + ":" + this.currentObsConf;
            } else if (this.currentObsStatus.length() > 0) {
                this.currentObsValue = String.valueOf(this.currentObsValue) + ":" + this.currentObsStatus;
            }
        }
    }

    private void flushDataLine() {
        this.flushObs();
        this.createSeriesKey();
        if (this.currentObsEndDate != null && this.currentObsStartDate != null) {
            if (this.currentDatasetHeader.getAction() == DATASET_ACTION.DELETE) {
                for (String time : this.dateIterationsMap.get(this.timeFormat).getIterations(this.currentObsStartDate, this.currentObsEndDate)) {
                    String reportedValue = this.dateValues.get(time);
                    if (reportedValue == null) continue;
                    EDI_TIME_FORMAT ediTimeFormat = EDI_TIME_FORMAT.parseTimeFormat(this.timeFormat, false);
                    time = ediTimeFormat.formatDate(this.dateMap.get(time));
                    this.outputObs(time, ediTimeFormat.getEdiValue(), reportedValue);
                }
            } else {
                ArrayList<DataGroup> dataGroupList = new ArrayList<DataGroup>();
                int noVal = 0;
                int numObs = 0;
                DataGroup currentDataGroup = null;
                List timeIterations = this.dateIterationsMap.get(this.timeFormat).getIterations(this.currentObsStartDate, this.currentObsEndDate);
                for (String time : timeIterations) {
                    ++numObs;
                    String reportedValue = this.dateValues.get(time);
                    if (reportedValue == null) {
                        ++noVal;
                        continue;
                    }
                    if (numObs == 1 || numObs > 9999 || noVal > 3) {
                        currentDataGroup = new DataGroup(time);
                        dataGroupList.add(currentDataGroup);
                        noVal = 0;
                        numObs = 1;
                    }
                    if (noVal > 0) {
                        currentDataGroup.addEmptyValues(noVal);
                        noVal = 0;
                    }
                    currentDataGroup.addObservationValue(time, reportedValue);
                }
                for (DataGroup currentGroup : dataGroupList) {
                    this.outputObs(currentGroup.getTimePeriod(), currentGroup.getTimeRangeFormat(), currentGroup.getDataLine());
                }
            }
            this.currentObsEndDate = null;
            this.currentObsStartDate = null;
            this.currentObsTime = null;
            this.dateValues = new HashMap<String, String>();
        } else if (this.currentSeriesKey.length() > 0 && !this.hasAttributes) {
            this.writeSegment((Object)((Object)EDI_PREFIX.DATASET_DATA) + this.currentSeriesKey + "'");
        }
    }

    private void outputObs(String timePeriod, String timeRange, String dataLine) {
        String segmentOutput = (Object)((Object)EDI_PREFIX.DATASET_DATA) + this.currentSeriesKey + ":" + timePeriod + ":" + timeRange + dataLine + "'";
        this.writeSegment(segmentOutput);
    }

    protected void writeInterchangeAdministration(InterchangeHeader header) {
        this.header = header;
        this.write(this.writer, (Object)((Object)EDI_PREFIX.MESSAGE_START) + "'");
        this.writeLineSeparator(this.writer);
        this.write(this.writer, header.toString());
        this.writeLineSeparator(this.writer);
    }

    private void write(OutputStreamWriter outputStreamWriter, String value) {
        try {
            outputStreamWriter.write(value);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write the string: " + value, e);
        }
    }

    private void writeLineSeparator(OutputStreamWriter outputStreamWriter) {
        try {
            outputStreamWriter.write(System.getProperty("line.separator"));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write!", e);
        }
    }

    protected void writeMessageIdentification(MessageIdentification messageId) {
        this.messageId = messageId;
        this.numLines = 1;
        ++this.numMessages;
        this.writeSegment(messageId.toString());
    }

    protected void writeMessageFunction(MESSSAGE_FUNCTION messagefunctionEnum) {
        this.writeSegment(String.valueOf(EDI_PREFIX.MESSAGE_FUNCTION.toString()) + messagefunctionEnum.getEDIString() + "'");
    }

    protected void writeStructureMaintAgency(String agencyId) {
        this.writeSegment(String.valueOf(EDI_PREFIX.MESSAGE_AGENCY.toString()) + agencyId + "'");
    }

    protected void writeRecievingAgency(String agencyId) {
        this.writeSegment(String.valueOf(EDI_PREFIX.RECIEVING_AGENCY.toString()) + agencyId + "'");
    }

    protected void writeSendingAgency(String agencyId) {
        this.writeSegment(String.valueOf(EDI_PREFIX.SENDING_AGENCY.toString()) + agencyId + "'");
    }

    protected void writeEndMessageAdministration() {
        this.writeSegment(String.valueOf(EDI_PREFIX.END_MESSAGE_ADMINISTRATION.toString()) + this.numLines + "+" + this.messageId.getMessageRefNum() + "'");
    }

    protected void writeEndMessage() {
        if (this.header != null) {
            this.write(this.writer, String.valueOf(EDI_PREFIX.END_MESSAGE.toString()) + this.numMessages + "+" + this.header.getInterchangeRef() + "'");
            this.writeLineSeparator(this.writer);
        }
    }

    protected void writeSegment(String str) {
        this.write(this.writer, str);
        this.writeLineSeparator(this.writer);
        ++this.numLines;
    }

    private void flushCurrentDataset() {
        if (this.currentDatasetHeader != null) {
            this.flushDataLine();
            if (this.hasFootnoteSection && (this.datasetAttributeWriter != null || this.seriesAttributeWriter != null || this.obsAttributeWriter != null)) {
                this.writeSegment(EDIDataWriterUtil.parseStartAttributes());
            }
            this.hasFootnoteSection = false;
            if (this.datasetAttributeWriter != null) {
                try {
                    this.datasetAttributeWriter.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to close: ", e);
                }
                this.writeAttributes(this.tmpAttributeFileDataset);
                this.datasetAttributeWriter = null;
            }
            if (this.seriesAttributeWriter != null) {
                try {
                    this.seriesAttributeWriter.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to close: ", e);
                }
                this.writeAttributes(this.tmpAttributeFileSeries);
                this.seriesAttributeWriter = null;
            }
            if (this.obsAttributeWriter != null) {
                try {
                    this.obsAttributeWriter.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to close: ", e);
                }
                this.writeAttributes(this.tmpAttributeFileObs);
                this.obsAttributeWriter = null;
            }
            this.currentSeriesKey = "";
            this.currentAttributeKey = null;
            this.currentObsStartDate = null;
            this.currentObsEndDate = null;
            this.currentObsTime = null;
            this.currentObsValue = "-";
            this.currentObsStatus = "";
            this.currentObsConf = "";
            this.currentObsPreBreak = "";
            this.keyValues.clear();
            this.writeEndMessageAdministration();
        }
    }

    public void close(DataWriterEngine.FooterMessage ... footer) {
        if (this.readerClosed) {
            return;
        }
        if (this.headerWritten) {
            this.flushCurrentDataset();
            this.writeEndMessage();
            try {
                this.writer.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to close!", e);
            }
        }
        this.readerClosed = true;
    }

    private void writeAttributes(WriteableDataLocation attributeFile) {
        BufferedReader br = null;
        if (attributeFile != null) {
            try {
                try {
                    br = new BufferedReader(new InputStreamReader(attributeFile.getInputStream(), "ISO-8859-1"));
                    String currentLine = br.readLine();
                    while (currentLine != null) {
                        this.writeSegment(currentLine);
                        currentLine = br.readLine();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                attributeFile.close();
            }
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("EDIDataWriterEngineImpl.java", EDIDataWriterEngineImpl.class);
        ajc$tjp_0 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "org.springframework.beans.factory.aspectj.ConfigurableObject", "", "", ""), 155);
        ajc$tjp_1 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "org.sdmxsource.sdmx.ediparser.engine.writer.impl.EDIDataWriterEngineImpl", "java.io.OutputStream", "out", ""), 155);
    }

    private class AttributeKeyCreator {
        private boolean[] keyPos;

        public AttributeKeyCreator(AttributeBean attribute) {
            this.keyPos = new boolean[EDIDataWriterEngineImpl.this.dimensionIds.size()];
            for (String currentRef : attribute.getDimensionReferences()) {
                this.keyPos[((EDIDataWriterEngineImpl)EDIDataWriterEngineImpl.this).dimensionIds.indexOf((Object)currentRef)] = true;
            }
        }

        public String createSubKey() {
            String[] keySplit = EDIDataWriterEngineImpl.this.currentSeriesKey.split(":");
            StringBuilder sb = new StringBuilder();
            String concat = "";
            int i = 0;
            while (i < this.keyPos.length) {
                sb.append(concat);
                if (this.keyPos[i]) {
                    sb.append(keySplit[i]);
                }
                concat = ":";
                ++i;
            }
            return sb.toString();
        }
    }

    private class DataGroup {
        private StringBuilder segmentSb = new StringBuilder();
        private String startPeriod;
        private String endPeriod;
        private String prepend = ":";

        public DataGroup(String startPeriod) {
            this.startPeriod = startPeriod;
            this.endPeriod = startPeriod;
        }

        public String getTimePeriod() {
            Date startDate = (Date)EDIDataWriterEngineImpl.this.dateMap.get(this.startPeriod);
            Date endDate = (Date)EDIDataWriterEngineImpl.this.dateMap.get(this.endPeriod);
            EDI_TIME_FORMAT ediTimeFormat = EDI_TIME_FORMAT.parseTimeFormat(EDIDataWriterEngineImpl.this.timeFormat, false);
            String dateToOutput = ediTimeFormat.formatDate(startDate);
            if (this.isRange()) {
                dateToOutput = String.valueOf(dateToOutput) + ediTimeFormat.formatDate(endDate);
            }
            return dateToOutput;
        }

        public String getDataLine() {
            return this.segmentSb.toString();
        }

        public String getTimeRangeFormat() {
            return EDI_TIME_FORMAT.parseTimeFormat(EDIDataWriterEngineImpl.this.timeFormat, this.isRange()).getEdiValue();
        }

        private boolean isRange() {
            return !this.startPeriod.equals(this.endPeriod);
        }

        public void addEmptyValues(int numVals) {
            int i = 0;
            while (i < numVals) {
                this.segmentSb.append("+");
                ++i;
            }
        }

        public void addObservationValue(String date, String value) {
            this.endPeriod = date;
            this.segmentSb.append(String.valueOf(this.prepend) + value);
            this.prepend = "+";
        }
    }

    private class DateIterations {
        private Date from;
        private Date to;
        private TIME_FORMAT format;
        private List<String> datesIterated;

        public DateIterations(TIME_FORMAT format) {
            this.format = format;
        }

        private List<String> getIterations(Date from, Date to) {
            List timeValues;
            if (this.from == null) {
                this.datesIterated = DateUtil.createTimeValues((Date)from, (Date)to, (TIME_FORMAT)this.format);
                this.from = from;
                this.to = to;
            }
            if (from.before(this.from)) {
                timeValues = DateUtil.createTimeValues((Date)from, (Date)this.from, (TIME_FORMAT)this.format);
                timeValues.remove(timeValues.size() - 1);
                this.datesIterated.addAll(0, timeValues);
                this.from = from;
            } else if (to.after(this.to)) {
                timeValues = DateUtil.createTimeValues((Date)this.to, (Date)to, (TIME_FORMAT)this.format);
                timeValues.remove(0);
                this.datesIterated.addAll(timeValues);
                this.to = to;
            }
            String dateFromStr = DateUtil.formatDate((Date)from, (TIME_FORMAT)this.format);
            String dateToStr = DateUtil.formatDate((Date)to, (TIME_FORMAT)this.format);
            int idxFrom = this.datesIterated.indexOf(dateFromStr);
            int idxTo = this.datesIterated.indexOf(dateToStr) + 1;
            return this.datesIterated.subList(idxFrom, idxTo);
        }
    }

    static enum POSITION {
        DATASET,
        GROUP,
        SERIES,
        OBS;

    }
}

