/*******************************************************************************
 * Copyright (c) 2013 Metadata Technology Ltd.
 *  
 * All rights reserved. This program and the accompanying materials are made 
 * available under the terms of the GNU Lesser General Public License v 3.0 
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl.html
 * 
 * This file is part of the SDMX Component Library.
 * 
 * The SDMX Component Library is free software: you can redistribute it and/or 
 * modify it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 * 
 * The SDMX Component Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser 
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License 
 * along with The SDMX Component Library If not, see 
 * http://www.gnu.org/licenses/lgpl.
 * 
 * Contributors:
 * Metadata Technology - initial API and implementation
 ******************************************************************************/
package org.sdmxsource.sdmx.ediparser.util;

import java.text.DateFormat;
import java.util.regex.Pattern;

import org.sdmxsource.sdmx.util.date.DateUtil;

public class EDIDateUtil {

	private static final String YEAR_SHORT = "[0-9][0-9]";
	private static final String YEAR_LONG = "[0-9][0-9][0-9][0-9]";
	private static final String MONTH_DAY = "((01|03|05|07|08|10|12)((0[1-9])|(1[0-9])|(2[0-9])|3[0-1])" +
											"|02-((0[1-9])|(1[0-9])|(2[0-9]))" +
											"|(04|06|09|11)((0[1-9])|(1[0-9])|(2[0-9])|30))";
	private static final String HOUR_MINUTE = "([0-1][0-9]|2[0-3])([0-5][0-9])";
	
	public static final String HALF_YEAR = YEAR_LONG+"[1-2]";
	public static final String QUATERLY = YEAR_LONG+"[1-4]";
	private static final String MONTHLY = YEAR_LONG+"(0[1-9]|1[1-2])";
	private static final String WEEKLY = YEAR_LONG+"[1-53]";
	
	public static final Pattern PATTERN_DAILY_SHORT_YEAR = Pattern.compile(YEAR_SHORT+MONTH_DAY);
	public static final Pattern PATTERN_DAILY_LONG_YEAR = Pattern.compile(YEAR_LONG+MONTH_DAY);
	public static final Pattern PATTERN_MINUTE_SHORT_YEAR = Pattern.compile(YEAR_SHORT+MONTH_DAY+HOUR_MINUTE);
	public static final Pattern PATTERN_MINUTE_LONG_YEAR = Pattern.compile(YEAR_LONG+MONTH_DAY+HOUR_MINUTE);
	public static final Pattern PATTERN_YEARLY = Pattern.compile(YEAR_LONG);
	public static final Pattern PATTERN_HALF_YEAR = Pattern.compile(HALF_YEAR);
	public static final Pattern PATTERN_QUATERLY = Pattern.compile(QUATERLY);
	public static final Pattern PATTERN_MONTHLY = Pattern.compile(MONTHLY);
	public static final Pattern PATTERN_WEEKLY = Pattern.compile(WEEKLY);
	
	public static final DateFormat DATE_FORMAT_DAILY_SHORT_YEAR = DateUtil.getDateFormatter("yyMMdd");
	public static final DateFormat DATE_FORMAT_DAILY_LONG_YEAR = DateUtil.getDateFormatter("yyyyMMdd");
	public static final DateFormat DATE_FORMAT_MINUTE_SHORT_YEAR = DateUtil.getDateFormatter("yyMMddHHmm");
	public static final DateFormat DATE_FORMAT_MINUTE_LONG_YEAR = DateUtil.getDateFormatter("yyyyMMddHHmm");
	public static final DateFormat DATE_FORMAT_YEARLY = DateUtil.getDateFormatter("yyyy");
	public static final DateFormat DATE_FORMAT_MONTHLY = DateUtil.getDateFormatter("yyyyMM");
	public static final DateFormat DATE_FORMAT_WEEKLY = DateUtil.getDateFormatter("yyyyww");
}
