/*******************************************************************************
 * Copyright (c) 2013 Metadata Technology Ltd.
 *  
 * All rights reserved. This program and the accompanying materials are made 
 * available under the terms of the GNU Lesser General Public License v 3.0 
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl.html
 * 
 * This file is part of the SDMX Component Library.
 * 
 * The SDMX Component Library is free software: you can redistribute it and/or 
 * modify it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 * 
 * The SDMX Component Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser 
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License 
 * along with The SDMX Component Library If not, see 
 * http://www.gnu.org/licenses/lgpl.
 * 
 * Contributors:
 * Metadata Technology - initial API and implementation
 ******************************************************************************/
package org.sdmxsource.sdmx.ediparser.model.document.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.sdmxsource.sdmx.ediparser.model.document.EDIDocumentPosition;
import org.sdmxsource.sdmx.ediparser.model.document.EDIMetadata;


public class EDIMetadataImpl implements EDIMetadata {
	public String receiverIdentification;
	public Date dateOfPreparation;
	public String interchangeReference;
	public String applicationReference;
	private String messageName;
	public List<EDIDocumentPosition> documentPositions = new ArrayList<EDIDocumentPosition>();
	public Date reportingBegin;
	public Date reportingEnd;
	public boolean isTest;
	
	public EDIMetadataImpl(String receiverIdentification,
			Date dateOfPreparation, String interchangeReference,
			String applicationReference,
			Date reportingBegin,
			Date reportingEnd,
			boolean isTest) {
		this.receiverIdentification = receiverIdentification;
		this.dateOfPreparation = dateOfPreparation;
		this.interchangeReference = interchangeReference;
		this.applicationReference = applicationReference;
		this.reportingBegin = reportingBegin;
		this.reportingEnd = reportingEnd;
		this.isTest = isTest;
	}
	
	public String getMessageName() {
		return messageName;
	}

	public void setMessageName(String messageName) {
		this.messageName = messageName;
	}

	@Override
	public String getReceiverIdentification() {
		return receiverIdentification;
	}

	@Override
	public Date getDateOfPreparation() {
		return dateOfPreparation;
	}

	@Override
	public String getInterchangeReference() {
		return interchangeReference;
	}

	@Override
	public String getApplicationReference() {
		return applicationReference;
	}
	
	@Override
	public void addDocumentIndex(EDIDocumentPosition index) {
		this.documentPositions.add(index);
	}

	@Override
	public List<EDIDocumentPosition> getDocumentIndex() {
		return documentPositions;
	}

	@Override
	public Date getReportingBegin() {
		return reportingBegin;
	}

	@Override
	public Date getReportingEnd() {
		return reportingEnd;
	}

	@Override
	public void setReportingBegin(Date date) {
		this.reportingBegin = date;
	}

	@Override
	public void setReportingEnd(Date date) {
		this.reportingEnd = date;
	}

	@Override
	public boolean isTest() {
		return this.isTest;
	}
}
