/*******************************************************************************
 * Copyright (c) 2013 Metadata Technology Ltd.
 *  
 * All rights reserved. This program and the accompanying materials are made 
 * available under the terms of the GNU Lesser General Public License v 3.0 
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl.html
 * 
 * This file is part of the SDMX Component Library.
 * 
 * The SDMX Component Library is free software: you can redistribute it and/or 
 * modify it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 * 
 * The SDMX Component Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser 
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License 
 * along with The SDMX Component Library If not, see 
 * http://www.gnu.org/licenses/lgpl.
 * 
 * Contributors:
 * Metadata Technology - initial API and implementation
 ******************************************************************************/
package org.sdmxsource.sdmx.ediparser.constants;

public enum EDI_PREFIX {
	MESSAGE_START("UNA:+.? "),
	INTERCHANGE_HEADER("UNB+"),
	MESSAGE_IDENTIFICATION("UNH+"),
	MESSAGE_FUNCTION("BGM+"),
	END_MESSAGE_ADMINISTRATION("UNT+"),
	END_MESSAGE("UNZ+"),
	CONTACT_INFORMATION("CTA+"),
	COMMUNICATION_NUMBER("COM+"),
	DATA_START("DSI+"),
	DATASET_ACTION("STS+3+"),
	DATASET_DATETIME("DTM+"),
	DATASET_SEND_METHOD("GIS+AR3"),
	DATASET_MISSING_VALUE_SYMBOL("GIS+1:::"),
	DATASET_DATA("ARR++"),
	DATASET_DATAATTRIBUTE("ARR+"),
	DATASET_FOOTNOTE_SECTION("FNS+"),
	DATASET_ATTRIBUTE_SCOPE("REL+Z01+"),
	DATASET_ATTRIBUTE_CODED("IDE+Z10+"),
	MESSAGE_ID_PROVIDED_BY_SENDER("IDE+10+"),
	DATASET_ATTRIBUTE_UNCODED("IDE+Z11+"),
	DSD_REFERENCE("IDE+5+"),
	MESSAGE_AGENCY("NAD+Z02+"),
	RECIEVING_AGENCY("NAD+MR+"),
	SENDING_AGENCY("NAD+MS+"),
	CODELIST("VLI+"),
	CODE_VALUE("CDV+"),
	DSD("ASI+"),
	ATTRIBUTE("SCD+Z09+"),
	DIMENSION("SCD+"),
	CONCEPT("STC+"),	
	STRING("FTX+ACM+++"),
	FIELD_LENGTH("ATT+3+5+:::"),
	USEAGE_STATUS("ATT+3+35+"),
	ATTRIBUTE_ATTACHMENT_VALUE("ATT+3+32+"),
	CODELIST_REFERENCE("IDE+1+");
	
	private String prefix;
	
	private EDI_PREFIX(String prefix) {
		this.prefix = prefix;
	}

	public String getPrefix() {
		return prefix;
	}
	
	public static EDI_PREFIX parseString(String str) {
		for(EDI_PREFIX currentPrefix : EDI_PREFIX.values()) {
			if(str.startsWith(currentPrefix.getPrefix())) {
				return currentPrefix;
			}
		}
		throw new IllegalArgumentException("Unknown EDI Prefix for Line : " +str);
	}
	

	/**
	 * Returns true if the current line is the message start
	 * @return
	 */
	public boolean isMessageStart() {
		return this == MESSAGE_START;
	}
	
	/**
	 * Returns true if the current line is the message start
	 * @return
	 */
	public boolean isInterchangeHeader() {
		return this == INTERCHANGE_HEADER;
	}
	/**
	 * Returns true if the current line is the message start
	 * @return
	 */
	public boolean isMessageIdentification() {
		return this == MESSAGE_IDENTIFICATION;
	}
	
	public boolean isEndMessageAdministration() {
		return this == END_MESSAGE_ADMINISTRATION;
	}
	
	public boolean isCodelistReference() {
		return this == CODELIST_REFERENCE;
	}
	public boolean isAttribute() {
		return this == ATTRIBUTE;
	}
	
	
	/**
	 * Returns true if the current line is the message start
	 * @return
	 */
	public boolean isMessageFunction() {
		return this == MESSAGE_FUNCTION;
	}
	
	public boolean isCodelistSegment() {
		return this == CODELIST;
	}
	
	public boolean isConceptSegment() {
		return this == CONCEPT;
	}
	
	public boolean isDSDSegment() {
		return this == DSD;
	}
	
	public boolean isStructureSegment() {
		return isCodelistSegment() || isConceptSegment() || isDSDSegment();
	}
	
	public boolean isDataSegment() {
		return this == DATA_START;
	}

	@Override
	public String toString() {
		return this.prefix;
	}
}
