/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.imageAnalysis.vectorizeTrees;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.IteratorException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.imageAnalysis.vectorizeTrees.Tree;
import es.unex.sextante.libMath.simpleStats.SimpleStats;
import es.unex.sextante.parameters.RasterLayerAndBand;
import es.unex.sextante.rasterWrappers.GridCell;
import es.unex.sextante.rasterWrappers.GridExtent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;

public class VectorizeTreesAlgorithm
extends GeoAlgorithm {
    private static final int[] m_iOffsetX;
    private static final int[] m_iOffsetY;
    public static final String INPUT = "INPUT";
    public static final String POLYGONS = "POLYGONS";
    public static final String TOLERANCE_SPECTRAL = "TOLERANCE_SPECTRAL";
    public static final String TOLERANCE_SIZE = "TOLERANCE_SIZE";
    public static final String MINSIZE = "MINSIZE";
    public static final String MAXSIZE = "MAXSIZE";
    public static final String TREES = "TREES";
    private static final int ANALIZED = 2;
    private int m_iMinX;
    private int m_iMinY;
    private IRasterLayer[] m_Window;
    private IRasterLayer m_BinaryImage;
    private ArrayList m_Bands;
    private IVectorLayer m_Polygons;
    private ArrayList m_Stats;
    private SimpleStats m_SizeStats;
    private IVectorLayer m_Trees;
    private ArrayList m_TreesArray;
    private double m_dTolerance;
    private double m_dToleranceSize;
    private double m_dMinSize;
    private double m_dMaxSize;
    private GeometryFactory m_GeometryFactory;
    private int[] m_iBand;

    static {
        int[] nArray = new int[8];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[5] = -1;
        nArray[6] = -1;
        nArray[7] = -1;
        m_iOffsetX = nArray;
        int[] nArray2 = new int[8];
        nArray2[0] = 1;
        nArray2[1] = 1;
        nArray2[3] = -1;
        nArray2[4] = -1;
        nArray2[5] = -1;
        nArray2[7] = 1;
        m_iOffsetY = nArray2;
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Detectar_y_vectorizar_arboles"));
        this.setGroup(Sextante.getText((String)"Tratamiento_y_analisis_de_imagenes"));
        this.setGeneratesUserDefinedRasterOutput(true);
        try {
            this.m_Parameters.addMultipleInput(INPUT, Sextante.getText((String)"Bandas_para_clasificacion"), 7, true);
            this.m_Parameters.addInputVectorLayer(POLYGONS, Sextante.getText((String)"Arboles_muestra"), 2, true);
            this.m_Parameters.addNumericalValue(TOLERANCE_SPECTRAL, Sextante.getText((String)"Tolerancia"), 2, 1.0, 0.0, Double.MAX_VALUE);
            this.m_Parameters.addNumericalValue(TOLERANCE_SIZE, Sextante.getText((String)"Tolerancia_tamano"), 2, 1.0, 0.0, Double.MAX_VALUE);
            this.addOutputVectorLayer(TREES, Sextante.getText((String)"Arboles"), 0);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_GeometryFactory = new GeometryFactory();
        this.m_Bands = this.m_Parameters.getParameterValueAsArrayList(INPUT);
        this.m_Polygons = this.m_Parameters.getParameterValueAsVectorLayer(POLYGONS);
        this.m_dTolerance = this.m_Parameters.getParameterValueAsDouble(TOLERANCE_SPECTRAL);
        this.m_dToleranceSize = this.m_Parameters.getParameterValueAsDouble(TOLERANCE_SIZE);
        this.m_TreesArray = new ArrayList();
        this.m_Trees = this.getNewVectorLayer(TREES, Sextante.getText((String)"Arboles"), 0, new Class[]{Integer.class, Double.class, Double.class}, new String[]{"ID", Sextante.getText((String)"Superficie"), Sextante.getText((String)"coef_forma")});
        this.m_SizeStats = new SimpleStats();
        this.getClassInformation();
        this.m_BinaryImage = this.getTempRasterLayer(0, this.m_GridExtent, 1);
        this.m_BinaryImage.setNoDataValue(0.0);
        int i = 0;
        while (i < this.m_Window.length) {
            this.m_Window[i].setWindowExtent(this.m_GridExtent);
            ++i;
        }
        this.doParalellpiped();
        this.detectAndVectorizeTrees();
        return !this.m_Task.isCanceled();
    }

    private void detectAndVectorizeTrees() {
        int iNX = this.m_BinaryImage.getWindowGridExtent().getNX();
        int iNY = this.m_BinaryImage.getWindowGridExtent().getNY();
        this.setProgressText(Sextante.getText((String)"Vectorizando"));
        int y = 0;
        while (y < iNY && this.setProgress(y, iNY)) {
            int x = 0;
            while (x < iNX) {
                double dValue = this.m_BinaryImage.getCellValueAsDouble(x, y);
                if (!this.m_BinaryImage.isNoDataValue(dValue) && dValue != 2.0) {
                    this.detectTree(x, y);
                }
                ++x;
            }
            ++y;
        }
        this.vectorize();
    }

    private void detectTree(int x, int y) {
        int iCells = 0;
        int xMax = Integer.MIN_VALUE;
        int yMax = Integer.MIN_VALUE;
        int xMin = Integer.MAX_VALUE;
        int yMin = Integer.MAX_VALUE;
        ArrayList<java.awt.Point> centralPoints = new ArrayList<java.awt.Point>();
        ArrayList<java.awt.Point> adjPoints = new ArrayList<java.awt.Point>();
        xMin = Math.min(xMin, x);
        yMin = Math.min(yMin, y);
        xMax = Math.max(xMax, x);
        yMax = Math.max(yMax, y);
        ++iCells;
        centralPoints.add(new java.awt.Point(x, y));
        this.m_BinaryImage.setCellValue(x, y, 2.0);
        while (centralPoints.size() != 0) {
            int iPt = 0;
            while (iPt < centralPoints.size()) {
                java.awt.Point point = (java.awt.Point)centralPoints.get(iPt);
                x = point.x;
                y = point.y;
                int n = 0;
                while (n < 8) {
                    int x2 = x + m_iOffsetX[n];
                    int y2 = y + m_iOffsetY[n];
                    double dValue = this.m_BinaryImage.getCellValueAsDouble(x2, y2);
                    if (!this.m_BinaryImage.isNoDataValue(dValue) && dValue != 2.0) {
                        this.m_BinaryImage.setCellValue(x2, y2, 2.0);
                        adjPoints.add(new java.awt.Point(x2, y2));
                        xMin = Math.min(xMin, x2);
                        yMin = Math.min(yMin, y2);
                        xMax = Math.max(xMax, x2);
                        yMax = Math.max(yMax, y2);
                        ++iCells;
                    }
                    ++n;
                }
                ++iPt;
            }
            centralPoints = adjPoints;
            adjPoints = new ArrayList();
            if (!this.m_Task.isCanceled()) continue;
            return;
        }
        if (Math.abs((double)iCells - this.m_SizeStats.getMean()) < this.m_SizeStats.getStdDev() * this.m_dToleranceSize) {
            Tree tree = new Tree();
            GridCell cellMin = new GridCell(xMin, yMin, 0.0);
            GridCell cellMax = new GridCell(xMax, yMax, 0.0);
            Point2D ptMin = this.m_GridExtent.getWorldCoordsFromGridCoords(cellMin);
            Point2D ptMax = this.m_GridExtent.getWorldCoordsFromGridCoords(cellMax);
            double xCenter = (ptMax.getX() + ptMin.getX()) / 2.0;
            double yCenter = (ptMax.getY() + ptMin.getY()) / 2.0;
            tree.center = new Point2D.Double(xCenter, yCenter);
            tree.dArea = iCells;
            tree.dPerimeter = (xMax - xMin + 1) * (yMax - yMin + 1);
            this.m_TreesArray.add(tree);
        }
    }

    private void vectorize() {
        int iTree = 1;
        int i = 0;
        while (i < this.m_TreesArray.size()) {
            Tree tree = (Tree)this.m_TreesArray.get(i);
            Object[] value = new Object[]{new Integer(iTree), new Double(tree.dArea), new Double(tree.getAreaPerimeterRatio())};
            Point pt = this.m_GeometryFactory.createPoint(new Coordinate(tree.center.getX(), tree.center.getY()));
            this.m_Trees.addFeature((Geometry)pt, value);
            ++iTree;
            ++i;
        }
    }

    private void getClassInformation() {
        this.m_Stats = new ArrayList();
        this.m_Window = new IRasterLayer[this.m_Bands.size()];
        this.m_iBand = new int[this.m_Bands.size()];
        int i = 0;
        while (i < this.m_Bands.size()) {
            RasterLayerAndBand rab = (RasterLayerAndBand)this.m_Bands.get(i);
            this.m_iBand[i] = rab.getBand();
            this.m_Window[i] = rab.getRasterLayer();
            GridExtent extent = this.getAdjustedGridExtent(i);
            this.m_Stats.add(new SimpleStats());
            this.m_Window[i].setWindowExtent(extent);
            ++i;
        }
        this.setProgressText(Sextante.getText((String)"Extrayendo_firmas_espectrales"));
        i = 0;
        int iShapeCount = this.m_Polygons.getShapesCount();
        IFeatureIterator featureIter = this.m_Polygons.iterator();
        while (featureIter.hasNext() && this.setProgress(i, iShapeCount)) {
            try {
                IFeature feature = featureIter.next();
                Geometry geometry = feature.getGeometry();
                this.doPolygon(geometry);
            }
            catch (IteratorException iteratorException) {
                // empty catch block
            }
        }
        featureIter.close();
    }

    private void doPolygon(Geometry geom) {
        int i = 0;
        while (i < geom.getNumGeometries()) {
            Geometry part = geom.getGeometryN(i);
            this.doPolygonPart(part);
            ++i;
        }
    }

    private void doPolygonPart(Geometry geom) {
        int iSize = 0;
        Envelope extent = geom.getEnvelopeInternal();
        Coordinate[] points = geom.getCoordinates();
        int i = 0;
        while (i < this.m_Window.length) {
            int xStop;
            Coordinate p = new Coordinate();
            SimpleStats substats = (SimpleStats)this.m_Stats.get(i);
            GridExtent ge = this.m_Window[i].getWindowGridExtent();
            int iNX = ge.getNX();
            int iNY = ge.getNY();
            boolean[] bCrossing = new boolean[iNX];
            int xStart = (int)((extent.getMinX() - ge.getXMin()) / ge.getCellSize()) - 1;
            if (xStart < 0) {
                xStart = 0;
            }
            if ((xStop = (int)((extent.getMaxX() - ge.getXMin()) / ge.getCellSize()) + 1) >= iNX) {
                xStop = iNX - 1;
            }
            int y = 0;
            double yPos = ge.getYMax();
            while (y < iNY) {
                if (yPos >= extent.getMinY() && yPos <= extent.getMaxY()) {
                    Arrays.fill(bCrossing, false);
                    Coordinate pLeft = new Coordinate(ge.getXMin() - 1.0, yPos);
                    Coordinate pRight = new Coordinate(ge.getXMax() + 1.0, yPos);
                    Coordinate pb = points[points.length - 1];
                    int iPoint = 0;
                    while (iPoint < points.length) {
                        Coordinate pa = pb;
                        pb = points[iPoint];
                        if (pa.y <= yPos && yPos < pb.y || pa.y > yPos && yPos >= pb.y) {
                            this.getCrossing(p, pa, pb, pLeft, pRight);
                            int ix = (int)((p.x - ge.getXMin()) / ge.getCellSize() + 1.0);
                            if (ix < 0) {
                                ix = 0;
                            } else if (ix >= iNX) {
                                ix = iNX - 1;
                            }
                            bCrossing[ix] = !bCrossing[ix];
                        }
                        ++iPoint;
                    }
                    int x = xStart;
                    boolean bFill = false;
                    while (x <= xStop) {
                        if (bCrossing[x]) {
                            boolean bl = bFill = !bFill;
                        }
                        if (bFill) {
                            ++iSize;
                            double dValue = this.m_Window[i].getCellValueAsDouble(x, y, this.m_iBand[i]);
                            if (!this.m_Window[i].isNoDataValue(dValue)) {
                                substats.addValue(dValue);
                            }
                        }
                        ++x;
                    }
                }
                ++y;
                yPos -= ge.getCellSize();
            }
            if (i == 0) {
                this.m_SizeStats.addValue((double)iSize);
            }
            ++i;
        }
    }

    private boolean getCrossing(Coordinate crossing, Coordinate a1, Coordinate a2, Coordinate b1, Coordinate b2) {
        double a_dx = a2.x - a1.x;
        double b_dy = b2.y - b1.y;
        double b_dx = b2.x - b1.x;
        double a_dy = a2.y - a1.y;
        double div = a_dx * b_dy - b_dx * a_dy;
        if (div != 0.0) {
            double lambda = ((b1.x - a1.x) * b_dy - b_dx * (b1.y - a1.y)) / div;
            crossing.x = a1.x + lambda * a_dx;
            crossing.y = a1.y + lambda * a_dy;
            return true;
        }
        return false;
    }

    private GridExtent getAdjustedGridExtent(int iLayer) {
        GridExtent ge = new GridExtent();
        Rectangle2D rect = this.m_Polygons.getFullExtent();
        double dMinX = this.m_Window[iLayer].getLayerGridExtent().getXMin();
        double dMinY = this.m_Window[iLayer].getLayerGridExtent().getYMin();
        double dCellSize = this.m_Window[iLayer].getLayerGridExtent().getCellSize();
        this.m_iMinX = (int)Math.floor((rect.getMinX() - dMinX) / dCellSize);
        double iMaxX = Math.ceil((rect.getMaxX() - dMinX) / dCellSize);
        this.m_iMinY = (int)Math.floor((rect.getMinY() - dMinY) / dCellSize);
        double iMaxY = Math.ceil((rect.getMaxY() - dMinY) / dCellSize);
        double dMinX2 = dMinX + (double)this.m_iMinX * dCellSize;
        double dMinY2 = dMinY + (double)this.m_iMinY * dCellSize;
        double dMaxX2 = dMinX + iMaxX * dCellSize;
        double dMaxY2 = dMinY + iMaxY * dCellSize;
        ge.setCellSize(dCellSize);
        ge.setXRange(dMinX2, dMaxX2);
        ge.setYRange(dMinY2, dMaxY2);
        return ge;
    }

    private boolean doParalellpiped() {
        double[] dMean = new double[this.m_Window.length];
        double[] dStdDev = new double[this.m_Window.length];
        int iNX = this.m_BinaryImage.getWindowGridExtent().getNX();
        int iNY = this.m_BinaryImage.getWindowGridExtent().getNY();
        int iGrid = 0;
        while (iGrid < this.m_Window.length) {
            SimpleStats substats = (SimpleStats)this.m_Stats.get(iGrid);
            dMean[iGrid] = substats.getMean();
            dStdDev[iGrid] = Math.sqrt(substats.getVariance());
            ++iGrid;
        }
        this.setProgressText(Sextante.getText((String)"Clasificando"));
        int y = 0;
        while (y < iNY && this.setProgress(y, iNY)) {
            int x = 0;
            while (x < iNX) {
                boolean bIsInParalellpiped = true;
                iGrid = 0;
                while (iGrid < this.m_Window.length) {
                    double dValue = this.m_Window[iGrid].getCellValueAsDouble(x, y, this.m_iBand[iGrid]);
                    if (!this.m_Window[iGrid].isNoDataValue(dValue)) {
                        if (Math.abs(dValue - dMean[iGrid]) > dStdDev[iGrid] * this.m_dTolerance) {
                            bIsInParalellpiped = false;
                            break;
                        }
                    } else {
                        bIsInParalellpiped = false;
                        break;
                    }
                    ++iGrid;
                }
                if (bIsInParalellpiped) {
                    this.m_BinaryImage.setCellValue(x, y, 1.0);
                } else {
                    this.m_BinaryImage.setNoData(x, y);
                }
                ++x;
            }
            ++y;
        }
        return true;
    }
}

