/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.imageAnalysis.pixelOpsBase;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public abstract class PixelOpsBaseAlgorithm
extends GeoAlgorithm {
    public static final String RESULT = "RESULT";
    public static final String IMAGE = "IMAGE";
    protected IRasterLayer m_Image;

    public void defineCharacteristics() {
        this.setGeneratesUserDefinedRasterOutput(true);
        this.setGroup(Sextante.getText((String)"Tratamiento_y_analisis_de_imagenes"));
        try {
            this.m_Parameters.addInputRasterLayer(IMAGE, Sextante.getText((String)"Imagen"), true);
            this.addOutputRasterLayer(RESULT, Sextante.getText((String)"Resultado"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.setValues();
        IRasterLayer result = this.getNewRasterLayer(RESULT, Sextante.getText((String)"Resultado"), this.m_Image.getDataType());
        int iNX = this.m_GridExtent.getNX();
        int iNY = this.m_GridExtent.getNY();
        this.setProgressText(Sextante.getText((String)"Procesando"));
        int y = 0;
        while (y < iNY && this.setProgress(y, iNY)) {
            int x = 0;
            while (x < iNX) {
                double dValue = this.m_Image.getCellValueAsDouble(x, y);
                if (!this.m_Image.isNoDataValue(dValue)) {
                    result.setCellValue(x, y, this.getValueAt(x, y));
                } else {
                    result.setNoData(x, y);
                }
                ++x;
            }
            ++y;
        }
        return !this.m_Task.isCanceled();
    }

    protected void setValues() throws GeoAlgorithmExecutionException {
        this.m_Image = this.m_Parameters.getParameterValueAsRasterLayer(IMAGE);
        this.m_Image.setFullExtent();
    }

    protected abstract double getValueAt(int var1, int var2);
}

