/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.imageAnalysis.his2rgb;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.OptionalParentParameterException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UndefinedParentParameterNameException;
import es.unex.sextante.rasterWrappers.GridExtent;

public class HIS2RGBAlgorithm
extends GeoAlgorithm {
    public static final String LAYERH = "LAYERH";
    public static final String LAYERI = "LAYERI";
    public static final String LAYERS = "LAYERS";
    public static final String BANDH = "BANDH";
    public static final String BANDI = "BANDI";
    public static final String BANDS = "BANDS";
    public static final String R = "R";
    public static final String G = "G";
    public static final String B = "B";

    public void defineCharacteristics() {
        this.setName("HIS -> RGB");
        this.setGroup(Sextante.getText((String)"Tratamiento_y_analisis_de_imagenes"));
        this.setGeneratesUserDefinedRasterOutput(true);
        try {
            this.m_Parameters.addInputRasterLayer(LAYERH, Sextante.getText((String)"Capa_h"), true);
            this.m_Parameters.addBand(BANDH, Sextante.getText((String)"Banda_h"), LAYERH);
            this.m_Parameters.addInputRasterLayer(LAYERI, Sextante.getText((String)"Capa_i"), true);
            this.m_Parameters.addBand(BANDI, Sextante.getText((String)"Banda_i"), LAYERI);
            this.m_Parameters.addInputRasterLayer(LAYERS, Sextante.getText((String)"Capa_s"), true);
            this.m_Parameters.addBand(BANDS, Sextante.getText((String)"Banda_s"), LAYERS);
            this.addOutputRasterLayer(R, R);
            this.addOutputRasterLayer(G, G);
            this.addOutputRasterLayer(B, B);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (UndefinedParentParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (OptionalParentParameterException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        IRasterLayer hLayer = this.m_Parameters.getParameterValueAsRasterLayer(LAYERH);
        IRasterLayer iLayer = this.m_Parameters.getParameterValueAsRasterLayer(LAYERI);
        IRasterLayer sLayer = this.m_Parameters.getParameterValueAsRasterLayer(LAYERS);
        int hBand = this.m_Parameters.getParameterValueAsInt(BANDH);
        int iBand = this.m_Parameters.getParameterValueAsInt(BANDI);
        int sBand = this.m_Parameters.getParameterValueAsInt(BANDS);
        IRasterLayer rLayer = this.getNewRasterLayer(R, R, 0);
        IRasterLayer gLayer = this.getNewRasterLayer(G, G, 0);
        IRasterLayer bLayer = this.getNewRasterLayer(B, B, 0);
        GridExtent extent = rLayer.getWindowGridExtent();
        hLayer.setWindowExtent(extent);
        sLayer.setWindowExtent(extent);
        iLayer.setWindowExtent(extent);
        int iNX = extent.getNX();
        int iNY = extent.getNY();
        int y = 0;
        while (y < iNY && this.setProgress(y, iNY)) {
            int x = 0;
            while (x < iNX) {
                int h = hLayer.getCellValueAsInt(x, y, hBand);
                byte i = iLayer.getCellValueAsByte(x, y, iBand);
                byte s = sLayer.getCellValueAsByte(x, y, sBand);
                if (hLayer.isNoDataValue((double)h) || iLayer.isNoDataValue((double)i) || sLayer.isNoDataValue((double)s)) {
                    rLayer.setNoData(x, y);
                    gLayer.setNoData(x, y);
                    bLayer.setNoData(x, y);
                } else {
                    byte g;
                    byte b;
                    byte r;
                    if (h <= 0 && h < 120) {
                        r = (byte)(1.0 + (double)s * Math.cos(h) / Math.cos(Math.toRadians(60 - h)) * (double)i);
                        b = (byte)(i * (1 - s));
                        g = (byte)(1 - r - b);
                    } else if (h < 240) {
                        g = (byte)(1.0 + (double)s * Math.cos(h -= 120) / Math.cos(Math.toRadians(60 - h)) * (double)i);
                        r = (byte)(i * (1 - s));
                        b = (byte)(1 - r - g);
                    } else {
                        b = (byte)(1.0 + (double)s * Math.cos(h -= 240) / Math.cos(Math.toRadians(60 - h)) * (double)i);
                        g = (byte)(i * (1 - s));
                        r = (byte)(1 - g - b);
                    }
                    rLayer.setCellValue(x, y, (double)r);
                    gLayer.setCellValue(x, y, (double)g);
                    bLayer.setCellValue(x, y, (double)b);
                }
                ++x;
            }
            ++y;
        }
        return !this.m_Task.isCanceled();
    }
}

