/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.imageAnalysis.erosionDilation;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class ErosionDilationAlgorithm
extends GeoAlgorithm {
    public static final int ERODE = 0;
    public static final int DILATE = 1;
    public static final String LAYER = "LAYER";
    public static final String OPERATION = "OPERATION";
    public static final String RADIUS = "RADIUS";
    public static final String RESULT = "RESULT";
    protected final byte NO_DATA = 0;
    private int m_iRadius;
    private boolean[][] m_bIsValidCell;
    private boolean[][] m_bIsForegroundCell;
    private IRasterLayer m_Image;
    private int m_iOperationType;

    public void defineCharacteristics() {
        String[] sMethod = new String[]{Sextante.getText((String)"Erosion"), Sextante.getText((String)"Dilatacion")};
        this.setGeneratesUserDefinedRasterOutput(false);
        this.setName(Sextante.getText((String)"Erosion_dilatacion"));
        this.setGroup(Sextante.getText((String)"Tratamiento_y_analisis_de_imagenes"));
        try {
            this.m_Parameters.addInputRasterLayer(LAYER, Sextante.getText((String)"Imagen"), true);
            this.m_Parameters.addSelection(OPERATION, Sextante.getText((String)"Operacion"), sMethod);
            this.m_Parameters.addNumericalValue(RADIUS, Sextante.getText((String)"Radio"), 1, 1.0, 1.0, 20.0);
            this.addOutputRasterLayer(RESULT, this.getName());
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int x;
        int iValidCells = 0;
        this.m_iRadius = this.m_Parameters.getParameterValueAsInt(RADIUS);
        this.m_iOperationType = this.m_Parameters.getParameterValueAsInt(OPERATION);
        this.m_Image = this.m_Parameters.getParameterValueAsRasterLayer(LAYER);
        this.m_Image.setFullExtent();
        IRasterLayer result = this.getNewRasterLayer(RESULT, this.getName(), 0, this.m_Image.getWindowGridExtent());
        result.setNoDataValue(0.0);
        result.assignNoData();
        int iNX = this.m_Image.getNX();
        int iNY = this.m_Image.getNY();
        this.m_bIsValidCell = new boolean[2 * this.m_iRadius + 1][2 * this.m_iRadius + 1];
        this.m_bIsForegroundCell = new boolean[2 * this.m_iRadius + 1][2 * this.m_iRadius + 1];
        int y = -this.m_iRadius;
        while (y < this.m_iRadius + 1) {
            x = -this.m_iRadius;
            while (x < this.m_iRadius + 1) {
                double dDist = Math.sqrt(x * x + y * y);
                if (dDist <= (double)this.m_iRadius) {
                    this.m_bIsValidCell[x + this.m_iRadius][y + this.m_iRadius] = true;
                    ++iValidCells;
                } else {
                    this.m_bIsValidCell[x + this.m_iRadius][y + this.m_iRadius] = false;
                }
                ++x;
            }
            ++y;
        }
        y = 0;
        while (y < iNY && this.setProgress(y, iNY)) {
            x = 0;
            while (x < iNX) {
                this.setNeighborhoodValues(x, y);
                result.setCellValue(x, y, (double)this.operate());
                ++x;
            }
            ++y;
        }
        return !this.m_Task.isCanceled();
    }

    private byte operate() {
        switch (this.m_iOperationType) {
            default: {
                int i = 0;
                while (i < this.m_bIsValidCell.length) {
                    int j = 0;
                    while (j < this.m_bIsValidCell[0].length) {
                        if (this.m_bIsValidCell[i][j] && !this.m_bIsForegroundCell[i][j]) {
                            return 0;
                        }
                        ++j;
                    }
                    ++i;
                }
                return 1;
            }
            case 1: 
        }
        int i = 0;
        while (i < this.m_bIsValidCell.length) {
            int j = 0;
            while (j < this.m_bIsValidCell[0].length) {
                if (this.m_bIsValidCell[i][j] && this.m_bIsForegroundCell[i][j]) {
                    return 1;
                }
                ++j;
            }
            ++i;
        }
        return 0;
    }

    private void setNeighborhoodValues(int iX, int iY) {
        int iCell = 0;
        int y = -this.m_iRadius;
        while (y < this.m_iRadius + 1) {
            int x = -this.m_iRadius;
            while (x < this.m_iRadius + 1) {
                if (this.m_bIsValidCell[x + this.m_iRadius][y + this.m_iRadius]) {
                    double dValue = this.m_Image.getCellValueAsDouble(iX + x, iY + y);
                    this.m_bIsForegroundCell[x + this.m_iRadius][y + this.m_iRadius] = !this.m_Image.isNoDataValue(dValue) && dValue != 0.0;
                    ++iCell;
                }
                ++x;
            }
            ++y;
        }
    }
}

