/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.imageAnalysis.equalize;

import es.unex.sextante.core.Sextante;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.imageAnalysis.pixelOpsBase.PixelOpsBaseAlgorithm;
import java.awt.image.DataBuffer;

public class EqualizeAlgorithm
extends PixelOpsBaseAlgorithm {
    private int[] m_Histogram;
    private double m_dRange;
    private double m_dMin;
    private int m_iCells;
    private int m_iSize;

    @Override
    public void defineCharacteristics() {
        super.defineCharacteristics();
        this.setName(Sextante.getText((String)"Ecualizacion"));
    }

    @Override
    protected double getValueAt(int x, int y) {
        double dValue = this.m_Image.getCellValueAsDouble(x, y);
        int iClass = (int)((dValue - this.m_dMin) / this.m_dRange * (double)this.m_iSize);
        return (double)this.m_Histogram[iClass] / (double)this.m_iCells * (double)this.m_iSize;
    }

    @Override
    protected void setValues() throws GeoAlgorithmExecutionException {
        super.setValues();
        this.m_Histogram = this.m_Image.getAccumulatedHistogram();
        this.m_iCells = this.m_Histogram[this.m_Histogram.length - 1];
        this.m_dMin = this.m_Image.getMinValue();
        this.m_dRange = this.m_Image.getMaxValue() - this.m_dMin;
        this.m_iSize = (int)Math.pow(2.0, DataBuffer.getDataTypeSize(this.m_Image.getDataType())) - 1;
    }
}

