/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.imageAnalysis.contrastStretching;

import es.unex.sextante.core.Sextante;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.imageAnalysis.pixelOpsBase.PixelOpsBaseAlgorithm;
import java.awt.image.DataBuffer;

public class ContrastStretchingAlgorithm
extends PixelOpsBaseAlgorithm {
    public static final String LOWER = "LOWER";
    public static final String UPPER = "UPPER";
    private int m_iUpper;
    private int m_iLower;
    private int[] m_Histogram;
    private int m_iSize;
    private double m_dUpper;
    private double m_dLower;
    private double m_dRange;

    @Override
    public void defineCharacteristics() {
        super.defineCharacteristics();
        this.setName(Sextante.getText((String)"Expansion_de_contraste"));
        try {
            this.m_Parameters.addNumericalValue(LOWER, Sextante.getText((String)"Percentil_inferior"), 1, 0.0, 0.0, 99.0);
            this.m_Parameters.addNumericalValue(UPPER, Sextante.getText((String)"Percentil_superior"), 1, 100.0, 1.0, 100.0);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    @Override
    protected void setValues() throws GeoAlgorithmExecutionException {
        super.setValues();
        this.m_Histogram = this.m_Image.getAccumulatedHistogram();
        double dMin = this.m_dLower = this.m_Image.getMinValue();
        double dMax = this.m_dUpper = this.m_Image.getMaxValue();
        double dRange = dMax - dMin;
        this.m_iLower = this.m_Parameters.getParameterValueAsInt(LOWER);
        this.m_iUpper = this.m_Parameters.getParameterValueAsInt(UPPER);
        if (this.m_iLower > this.m_iUpper) {
            int iSwap = this.m_iUpper;
            this.m_iUpper = this.m_iLower;
            this.m_iLower = iSwap;
        }
        this.m_iSize = (int)(Math.pow(2.0, DataBuffer.getDataTypeSize(this.m_Image.getDataType())) / 2.0) - 1;
        this.m_iLower = (int)((double)this.m_Histogram[this.m_Histogram.length - 1] * (double)this.m_iLower / 100.0);
        this.m_iUpper = (int)((double)this.m_Histogram[this.m_Histogram.length - 1] * (double)this.m_iUpper / 100.0);
        int i = 0;
        while (i < this.m_Histogram.length - 1) {
            if (this.m_Histogram[i] < this.m_iLower && this.m_Histogram[i + 1] > this.m_iLower) {
                this.m_dLower = dMin + (double)(i + 1) * dRange / (double)this.m_iSize;
            }
            if (this.m_Histogram[i] < this.m_iUpper && this.m_Histogram[i + 1] > this.m_iUpper) {
                this.m_dUpper = dMin + (double)(i + 1) * dRange / (double)this.m_iSize;
            }
            ++i;
        }
        this.m_dRange = this.m_dUpper - this.m_dLower;
    }

    @Override
    protected double getValueAt(int x, int y) {
        double dValue = this.m_Image.getCellValueAsDouble(x, y);
        double dRet = (dValue - this.m_dLower) / this.m_dRange * (double)this.m_iSize;
        if (dRet > (double)this.m_iSize) {
            dRet = this.m_iSize;
        }
        if (dRet < 0.0) {
            dRet = 0.0;
        }
        return dRet;
    }
}

