/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.imageAnalysis.calibrateRegression;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.libMath.regression.Regression;

public class CalibrateRegressionAlgorithm
extends GeoAlgorithm {
    public static final String CALIBRATED = "CALIBRATED";
    public static final String INPUT = "INPUT";
    public static final String REF = "REF";

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Calibrar_una_imagen_mediante_regresion"));
        this.setGeneratesUserDefinedRasterOutput(false);
        this.setGroup(Sextante.getText((String)"Tratamiento_y_analisis_de_imagenes"));
        try {
            this.m_Parameters.addInputRasterLayer(INPUT, Sextante.getText((String)"Imagen_a_calibrar"), true);
            this.m_Parameters.addInputRasterLayer(REF, Sextante.getText((String)"Imagen_de_referencia"), false);
            this.addOutputRasterLayer(CALIBRATED, Sextante.getText((String)"Imagen_calibrada"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        double dCellValue;
        int x;
        Regression regression = new Regression();
        IRasterLayer input = this.m_Parameters.getParameterValueAsRasterLayer(INPUT);
        IRasterLayer ref = this.m_Parameters.getParameterValueAsRasterLayer(REF);
        input.setFullExtent();
        ref.setWindowExtent(input.getWindowGridExtent());
        IRasterLayer output = this.getNewRasterLayer(CALIBRATED, Sextante.getText((String)"Imagen_calibrada"), input.getDataType(), input.getWindowGridExtent());
        if (ref.getDataType() == 3 || ref.getDataType() == 2) {
            ref.setInterpolationMethod(0);
        }
        int iNX = input.getNX();
        int iNY = input.getNY();
        int y = 0;
        while (y < iNY && this.setProgress(y, iNY)) {
            x = 0;
            while (x < iNX) {
                dCellValue = input.getCellValueAsDouble(x, y);
                double dCellValue2 = ref.getCellValueAsDouble(x, y);
                if (!input.isNoDataValue(dCellValue) && !ref.isNoDataValue(dCellValue2)) {
                    regression.addValue(dCellValue, dCellValue2);
                }
                ++x;
            }
            ++y;
        }
        regression.calculate();
        y = 0;
        while (y < iNY && this.setProgress(y, iNY)) {
            x = 0;
            while (x < iNX) {
                dCellValue = input.getCellValueAsDouble(x, y);
                if (input.isNoDataValue(dCellValue)) {
                    output.setNoData(x, y);
                } else {
                    output.setCellValue(x, y, regression.getY(dCellValue));
                }
                ++x;
            }
            ++y;
        }
        return !this.m_Task.isCanceled();
    }
}

