/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.imageAnalysis.calibrate;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class CalibrateAlgorithm
extends GeoAlgorithm {
    private static final String INPUT = "INPUT";
    private static final String METHOD = "METHOD";
    private static final String STDDEV = "STDDEV";
    private static final String MEAN = "MEAN";
    private static final String GAIN = "GAIN";
    private static final String OFFSET = "OFFSET";
    private static final String CALIBRATED = "CALIBRATED";

    public void defineCharacteristics() {
        String[] sMethod = new String[]{Sextante.getText((String)"Media_y_desviacion"), Sextante.getText((String)"Amplificacion_desfase")};
        this.setName(Sextante.getText((String)"Calibrar_una_imagen"));
        this.setGroup(Sextante.getText((String)"Tratamiento_y_analisis_de_imagenes"));
        this.setGeneratesUserDefinedRasterOutput(false);
        try {
            this.m_Parameters.addInputRasterLayer(INPUT, Sextante.getText((String)"Imagen_a_calibrar"), true);
            this.m_Parameters.addSelection(METHOD, Sextante.getText((String)"Metodo"), sMethod);
            this.m_Parameters.addNumericalValue(STDDEV, Sextante.getText((String)"Desviacion_tipica_resultante"), 1.0, 2);
            this.m_Parameters.addNumericalValue(MEAN, Sextante.getText((String)"Media_resultante"), 0.0, 2);
            this.m_Parameters.addNumericalValue(GAIN, Sextante.getText((String)"Amplificacion"), 1.0, 2);
            this.m_Parameters.addNumericalValue(OFFSET, Sextante.getText((String)"Desfase"), 0.0, 2);
            this.addOutputRasterLayer(CALIBRATED, Sextante.getText((String)"Imagen_calibrada"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        IRasterLayer input = this.m_Parameters.getParameterValueAsRasterLayer(INPUT);
        double dMean = this.m_Parameters.getParameterValueAsDouble(MEAN);
        double dStdDev = this.m_Parameters.getParameterValueAsDouble(STDDEV);
        double dGain = this.m_Parameters.getParameterValueAsDouble(GAIN);
        double dOffset = this.m_Parameters.getParameterValueAsDouble(OFFSET);
        int iMethod = this.m_Parameters.getParameterValueAsInt(METHOD);
        input.setFullExtent();
        IRasterLayer output = this.getNewRasterLayer(CALIBRATED, Sextante.getText((String)"Imagen_calibrada"), input.getDataType(), input.getWindowGridExtent());
        int iNX = input.getNX();
        int iNY = input.getNY();
        if (iMethod == 0) {
            double dMeanIn = input.getMeanValue();
            double dStdDevIn = Math.sqrt(input.getVariance());
            int y = 0;
            while (y < iNY && this.setProgress(y, iNY)) {
                int x = 0;
                while (x < iNX) {
                    double dCellValue = input.getCellValueAsDouble(x, y);
                    if (input.isNoDataValue(dCellValue)) {
                        output.setNoData(x, y);
                    } else {
                        double dOutput = (dCellValue - dMeanIn) / dStdDevIn * dStdDev + dMean;
                        output.setCellValue(x, y, dOutput);
                    }
                    ++x;
                }
                ++y;
            }
        } else {
            int y = 0;
            while (y < iNY && this.setProgress(y, iNY)) {
                int x = 0;
                while (x < iNX) {
                    double dCellValue = input.getCellValueAsDouble(x, y);
                    if (input.isNoDataValue(dCellValue)) {
                        output.setNoData(x, y);
                    } else {
                        output.setCellValue(x, y, dGain * dCellValue + dOffset);
                    }
                    ++x;
                }
                ++y;
            }
        }
        return !this.m_Task.isCanceled();
    }
}

