/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.jms;

import javax.jms.JMSException;
import javax.jms.Message;
import org.springframework.batch.item.UnexpectedInputException;
import org.springframework.batch.retry.interceptor.MethodArgumentsKeyGenerator;

public class JmsMethodArgumentsKeyGenerator
implements MethodArgumentsKeyGenerator {
    public Object getKey(Object[] items) {
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            if (item instanceof Message) {
                try {
                    return ((Message)item).getJMSMessageID();
                }
                catch (JMSException e) {
                    throw new UnexpectedInputException("Could not extract message ID", e);
                }
            }
            ++n2;
        }
        if (items.length == 0) {
            throw new IllegalArgumentException("Method parameters are empty.  The key generator cannot determine a unique key.");
        }
        return items[0];
    }
}

