/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database;

import org.hibernate.Query;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.support.AbstractItemCountingItemStreamItemReader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateCursorItemReader<T>
extends AbstractItemCountingItemStreamItemReader<T>
implements ItemStream,
InitializingBean {
    private SessionFactory sessionFactory;
    private StatelessSession statelessSession;
    private Session statefulSession;
    private ScrollableResults cursor;
    private String queryString = "";
    private String queryName = "";
    private boolean useStatelessSession = true;
    private boolean initialized = false;
    private int fetchSize = 0;

    public HibernateCursorItemReader() {
        this.setName(ClassUtils.getShortName(HibernateCursorItemReader.class));
    }

    private Query createQuery() {
        if (this.useStatelessSession) {
            this.statelessSession = this.sessionFactory.openStatelessSession();
            if (StringUtils.hasText((String)this.queryName)) {
                return this.statelessSession.getNamedQuery(this.queryName);
            }
            return this.statelessSession.createQuery(this.queryString);
        }
        this.statefulSession = this.sessionFactory.openSession();
        if (StringUtils.hasText((String)this.queryName)) {
            return this.statefulSession.getNamedQuery(this.queryName);
        }
        return this.statefulSession.createQuery(this.queryString);
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.sessionFactory, (String)"session factory must be set");
        Assert.isTrue((this.fetchSize >= 0 ? 1 : 0) != 0, (String)"fetchSize must not be negative");
        Assert.isTrue((boolean)(StringUtils.hasText((String)this.queryString) ^ StringUtils.hasText((String)this.queryName)), (String)"exactly one of queryString or queryName must be set");
    }

    public void setQueryName(String queryName) {
        this.queryName = queryName;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public void setUseStatelessSession(boolean useStatelessSession) {
        Assert.state((!this.initialized ? 1 : 0) != 0);
        this.useStatelessSession = useStatelessSession;
    }

    @Override
    public void update(ExecutionContext executionContext) throws ItemStreamException {
        super.update(executionContext);
        if (!this.useStatelessSession) {
            this.statefulSession.clear();
        }
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    @Override
    protected T doRead() throws Exception {
        if (this.cursor.next()) {
            Object[] data = this.cursor.get();
            if (data.length > 1) {
                Object[] item = data;
                return (T)item;
            }
            Object item = data[0];
            return (T)item;
        }
        return null;
    }

    @Override
    protected void doOpen() throws Exception {
        Assert.state((!this.initialized ? 1 : 0) != 0, (String)"Cannot open an already opened ItemReader, call close first");
        this.cursor = this.createQuery().setFetchSize(this.fetchSize).scroll(ScrollMode.FORWARD_ONLY);
        this.initialized = true;
    }

    @Override
    protected void doClose() throws Exception {
        this.initialized = false;
        if (this.cursor != null) {
            this.cursor.close();
        }
        if (this.useStatelessSession) {
            if (this.statelessSession != null) {
                this.statelessSession.close();
            }
        } else if (this.statefulSession != null) {
            this.statefulSession.close();
        }
    }
}

