/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.updatecenter.common;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.sonar.updatecenter.common.Artifact;
import org.sonar.updatecenter.common.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Release
implements Comparable<Release> {
    private Artifact artifact;
    private Version version;
    private String description;
    private String downloadUrl;
    private String changelogUrl;
    private Release parent;
    private Set<Release> children;
    private Set<Release> outgoingDependencies;
    private Set<Release> incomingDependencies;
    private SortedSet<Version> requiredSonarVersions;
    private Date date;

    public Release(Artifact artifact, Version version) {
        this.artifact = artifact;
        this.version = version;
        this.requiredSonarVersions = Sets.newTreeSet();
        this.children = Sets.newHashSet();
        this.outgoingDependencies = Sets.newHashSet();
        this.incomingDependencies = Sets.newHashSet();
    }

    public Release(Artifact artifact, String version) {
        this(artifact, Version.create(version));
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public Version getVersion() {
        return this.version;
    }

    public Release setVersion(Version version) {
        this.version = version;
        return this;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public Release setDownloadUrl(String s) {
        this.downloadUrl = s;
        return this;
    }

    public String getFilename() {
        return StringUtils.substringAfterLast((String)this.downloadUrl, (String)"/");
    }

    public SortedSet<Version> getRequiredSonarVersions() {
        return this.requiredSonarVersions;
    }

    public boolean supportSonarVersion(Version version) {
        return this.requiredSonarVersions.contains(version);
    }

    public Release addRequiredSonarVersions(Version ... versions) {
        if (versions != null) {
            this.requiredSonarVersions.addAll(Arrays.asList(versions));
        }
        return this;
    }

    public Release addRequiredSonarVersions(String ... versions) {
        if (versions != null) {
            for (String v : versions) {
                this.requiredSonarVersions.add(Version.create(v));
            }
        }
        return this;
    }

    public Version getLastRequiredSonarVersion() {
        if (!this.requiredSonarVersions.isEmpty()) {
            return this.requiredSonarVersions.last();
        }
        return null;
    }

    public Version getMinimumRequiredSonarVersion() {
        if (!this.requiredSonarVersions.isEmpty()) {
            return this.requiredSonarVersions.first();
        }
        return null;
    }

    public Date getDate() {
        return this.date;
    }

    public Release setDate(Date date) {
        this.date = date;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Release setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getChangelogUrl() {
        return this.changelogUrl;
    }

    public Release setChangelogUrl(String changelogUrl) {
        this.changelogUrl = changelogUrl;
        return this;
    }

    public Release getParent() {
        return this.parent;
    }

    public Release setParent(Release parent) {
        this.parent = parent;
        return this;
    }

    public Collection<Release> getChildren() {
        return this.children;
    }

    public Release addChild(Release release) {
        this.children.add(release);
        return this;
    }

    @Nullable
    @VisibleForTesting
    Release getChild(final String key) {
        return (Release)Iterables.find(this.children, (Predicate)new Predicate<Release>(){

            public boolean apply(Release input) {
                return input.getArtifact().getKey().equals(key);
            }
        }, null);
    }

    public Set<Release> getOutgoingDependencies() {
        return ImmutableSortedSet.copyOf(this.outgoingDependencies);
    }

    public Release addOutgoingDependency(Release required) {
        this.outgoingDependencies.add(required);
        return this;
    }

    public Set<Release> getIncomingDependencies() {
        return ImmutableSortedSet.copyOf(this.incomingDependencies);
    }

    public Release addIncomingDependency(Release required) {
        this.incomingDependencies.add(required);
        return this;
    }

    public boolean isMaster() {
        return this.getParent() == null;
    }

    public String getKey() {
        return this.getArtifact().getKey();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Release release = (Release)o;
        if (!this.artifact.equals(release.artifact)) {
            return false;
        }
        return this.version.equals(release.version);
    }

    public int hashCode() {
        int result = this.artifact.hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("version", (Object)this.version).append("downloadUrl", (Object)this.downloadUrl).append("changelogUrl", (Object)this.changelogUrl).append("description", (Object)this.description).toString();
    }

    @Override
    public int compareTo(Release o) {
        return this.getVersion().compareTo(o.getVersion());
    }
}

