/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.updatecenter.common;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.sonar.updatecenter.common.Plugin;
import org.sonar.updatecenter.common.Release;
import org.sonar.updatecenter.common.Version;
import org.sonar.updatecenter.common.exception.DependencyCycleException;
import org.sonar.updatecenter.common.exception.IncompatiblePluginVersionException;
import org.sonar.updatecenter.common.exception.PluginNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginReferential {
    private Set<Plugin> plugins = Sets.newTreeSet();

    private PluginReferential() {
    }

    public static PluginReferential create(List<Plugin> pluginList) {
        PluginReferential pluginReferential = new PluginReferential();
        for (Plugin plugin : pluginList) {
            pluginReferential.add(plugin);
        }
        return pluginReferential;
    }

    public static PluginReferential createEmpty() {
        return PluginReferential.create(Lists.newArrayList());
    }

    public List<Plugin> getLastMasterReleasePlugins() {
        return Lists.newArrayList((Iterable)Iterables.filter(this.plugins, (Predicate)new Predicate<Plugin>(){

            public boolean apply(Plugin input) {
                return input.getLastRelease().isMaster();
            }
        }));
    }

    public List<Plugin> getPlugins() {
        return Lists.newArrayList(this.plugins);
    }

    public Plugin findPlugin(final String key) {
        return (Plugin)Iterables.find(this.plugins, (Predicate)new Predicate<Plugin>(){

            public boolean apply(Plugin input) {
                return input.getKey().equals(key);
            }
        });
    }

    public boolean doesContainPlugin(final String key) {
        return Iterables.any(this.plugins, (Predicate)new Predicate<Plugin>(){

            public boolean apply(Plugin input) {
                return input.getKey().equals(key);
            }
        });
    }

    public boolean doesContainRelease(String key, Version version) {
        for (Plugin plugin : this.plugins) {
            Release pluginRelease;
            if (!plugin.getKey().equals(key) || (pluginRelease = plugin.getRelease(version)) == null) continue;
            return true;
        }
        return false;
    }

    public List<String> findLastReleasesWithDependencies(String pluginKey) {
        ArrayList removablePlugins = Lists.newArrayList();
        Plugin plugin = this.findPlugin(pluginKey);
        if (plugin != null) {
            Release pluginRelease = plugin.getLastRelease();
            removablePlugins.add(plugin.getKey());
            for (Release child : pluginRelease.getChildren()) {
                removablePlugins.add(child.getKey());
            }
            for (Release incomingDependencies : pluginRelease.getIncomingDependencies()) {
                removablePlugins.addAll(this.findLastReleasesWithDependencies(incomingDependencies.getArtifact().getKey()));
            }
        }
        return removablePlugins;
    }

    public void setParent(Release release, String parentKey) {
        try {
            Plugin pluginParent = this.findPlugin(parentKey);
            Version version = release.getVersion();
            Release parent = pluginParent.getRelease(version);
            if (parent == null) {
                throw new IncompatiblePluginVersionException("The plugins '" + release.getKey() + "' and '" + parentKey + "' must have exactly the same version as they belong to the same group.");
            }
            release.setParent(parent);
            parent.addChild(release);
        }
        catch (NoSuchElementException e) {
            throw new PluginNotFoundException("The plugin '" + parentKey + "' required by the plugin '" + release.getKey() + "' is missing.", e);
        }
    }

    public void addOutgoingDependency(Release release, String requiredPluginReleaseKey, String requiredMinimumReleaseVersion) {
        try {
            Plugin requiredPlugin = this.findPlugin(requiredPluginReleaseKey);
            Release minimalRequiredRelease = requiredPlugin.getMinimalRelease(Version.create(requiredMinimumReleaseVersion));
            if (minimalRequiredRelease != null) {
                release.addOutgoingDependency(minimalRequiredRelease);
                minimalRequiredRelease.addIncomingDependency(release);
                this.checkDependencyCycle(release);
            } else {
                Release latest = requiredPlugin.getLastRelease();
                if (latest != null) {
                    throw new IncompatiblePluginVersionException("The plugin '" + requiredPlugin.getKey() + "' is in version " + latest.getVersion().getName() + " whereas the plugin '" + release.getArtifact().getKey() + "' requires a least a version " + requiredMinimumReleaseVersion + ".");
                }
            }
        }
        catch (NoSuchElementException e) {
            throw new PluginNotFoundException("The plugin '" + requiredPluginReleaseKey + "' required by '" + release.getArtifact().getKey() + "' is missing.", e);
        }
    }

    private void checkDependencyCycle(Release release) {
        ArrayList releases = Lists.newArrayList();
        try {
            this.checkDependencyCycle(release, releases);
        }
        catch (DependencyCycleException e) {
            ArrayList releaseKeys = Lists.newArrayList((Iterable)Iterables.transform((Iterable)releases, (Function)new Function<Release, String>(){

                public String apply(Release input) {
                    return input.getArtifact().getKey();
                }
            }));
            throw new DependencyCycleException("There is a dependency cycle between plugins '" + Joiner.on((String)"', '").join((Iterable)releaseKeys) + "' that must be cut.", e);
        }
    }

    private void checkDependencyCycle(Release release, List<Release> releases) {
        for (Release outgoingDependency : release.getOutgoingDependencies()) {
            if (releases.contains(outgoingDependency)) {
                throw new DependencyCycleException();
            }
            releases.add(outgoingDependency);
            this.checkDependencyCycle(outgoingDependency, releases);
        }
    }

    List<Release> getLastMasterReleases() {
        ArrayList releases = Lists.newArrayList();
        for (Plugin plugin : this.getLastMasterReleasePlugins()) {
            releases.add(plugin.getLastRelease());
        }
        return releases;
    }

    private PluginReferential add(Plugin plugin) {
        this.plugins.add(plugin);
        return this;
    }
}

