/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.updatecenter.common;

import org.apache.commons.lang.StringUtils;

public final class PluginKeyUtils {
    private PluginKeyUtils() {
    }

    public static String sanitize(String mavenArtifactId) {
        if (mavenArtifactId == null) {
            return null;
        }
        String key = mavenArtifactId;
        if (StringUtils.startsWith((String)mavenArtifactId, (String)"sonar-") && StringUtils.endsWith((String)mavenArtifactId, (String)"-plugin")) {
            key = StringUtils.removeEnd((String)StringUtils.removeStart((String)mavenArtifactId, (String)"sonar-"), (String)"-plugin");
        } else if (StringUtils.endsWith((String)mavenArtifactId, (String)"-sonar-plugin")) {
            key = StringUtils.removeEnd((String)mavenArtifactId, (String)"-sonar-plugin");
        }
        return PluginKeyUtils.keepLettersAndDigits(key);
    }

    private static String keepLettersAndDigits(String key) {
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < key.length(); ++index) {
            char character = key.charAt(index);
            if (!Character.isLetter(character) && !Character.isDigit(character)) continue;
            sb.append(character);
        }
        return sb.toString();
    }

    public static boolean isValid(String pluginKey) {
        return StringUtils.isNotBlank((String)pluginKey) && StringUtils.isAlphanumeric((String)pluginKey);
    }
}

