/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.duplications.detector.suffixtree;

import org.sonar.duplications.detector.suffixtree.Edge;
import org.sonar.duplications.detector.suffixtree.Node;

public final class Suffix {
    private Node originNode;
    private int beginIndex;
    private int endIndex;

    public Suffix(Node originNode, int beginIndex, int endIndex) {
        this.originNode = originNode;
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
    }

    public boolean isExplicit() {
        return this.beginIndex > this.endIndex;
    }

    public boolean isImplicit() {
        return !this.isExplicit();
    }

    public void canonize() {
        if (this.isImplicit()) {
            Edge edge = this.originNode.findEdge(this.originNode.symbolAt(this.beginIndex));
            int edgeSpan = edge.getSpan();
            while (edgeSpan <= this.getSpan()) {
                this.beginIndex += edgeSpan + 1;
                this.originNode = edge.getEndNode();
                if (this.beginIndex > this.endIndex) continue;
                edge = edge.getEndNode().findEdge(this.originNode.symbolAt(this.beginIndex));
                edgeSpan = edge.getSpan();
            }
        }
    }

    public int getSpan() {
        return this.endIndex - this.beginIndex;
    }

    public Node getOriginNode() {
        return this.originNode;
    }

    public int getBeginIndex() {
        return this.beginIndex;
    }

    public void incBeginIndex() {
        ++this.beginIndex;
    }

    public void changeOriginNode() {
        this.originNode = this.originNode.getSuffixNode();
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public void incEndIndex() {
        ++this.endIndex;
    }
}

