/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan.filesystem;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchComponent;
import org.sonar.api.batch.ResourceFilter;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.ResourceUtils;
import org.sonar.api.scan.filesystem.FileExclusions;
import org.sonar.api.scan.filesystem.FileSystemFilter;
import org.sonar.api.scan.filesystem.FileType;
import org.sonar.batch.scan.filesystem.PathPattern;

public class ExclusionFilters
implements FileSystemFilter,
ResourceFilter,
BatchComponent {
    private final FileExclusions exclusionSettings;

    public ExclusionFilters(FileExclusions exclusions) {
        this.exclusionSettings = exclusions;
    }

    public void start() {
        this.log("Included sources: ", this.sourceInclusions());
        this.log("Excluded sources: ", this.sourceExclusions());
        this.log("Included tests: ", this.testInclusions());
        this.log("Excluded tests: ", this.testExclusions());
    }

    private void log(String title, PathPattern[] patterns) {
        if (patterns.length > 0) {
            Logger log = LoggerFactory.getLogger(ExclusionFilters.class);
            log.info(title);
            for (PathPattern pattern : patterns) {
                log.info("  " + pattern);
            }
        }
    }

    public boolean accept(File file, FileSystemFilter.Context context) {
        PathPattern[] inclusionPatterns;
        PathPattern[] pathPatternArray = inclusionPatterns = context.type() == FileType.TEST ? this.testInclusions() : this.sourceInclusions();
        if (inclusionPatterns.length > 0) {
            boolean matchInclusion = false;
            for (PathPattern pattern : inclusionPatterns) {
                matchInclusion |= pattern.match(context);
            }
            if (!matchInclusion) {
                return false;
            }
        }
        PathPattern[] exclusionPatterns = context.type() == FileType.TEST ? this.testExclusions() : this.sourceExclusions();
        for (PathPattern pattern : exclusionPatterns) {
            if (!pattern.match(context)) continue;
            return false;
        }
        return true;
    }

    public boolean isIgnored(Resource resource) {
        if (ResourceUtils.isFile((Resource)resource)) {
            PathPattern[] inclusionPatterns;
            PathPattern[] pathPatternArray = inclusionPatterns = ResourceUtils.isUnitTestClass((Resource)resource) ? this.testInclusions() : this.sourceInclusions();
            if (this.isIgnoredByInclusions(resource, inclusionPatterns)) {
                return true;
            }
            PathPattern[] exclusionPatterns = ResourceUtils.isUnitTestClass((Resource)resource) ? this.testExclusions() : this.sourceExclusions();
            return this.isIgnoredByExclusions(resource, exclusionPatterns);
        }
        return false;
    }

    private boolean isIgnoredByInclusions(Resource resource, PathPattern[] inclusionPatterns) {
        if (inclusionPatterns.length > 0) {
            boolean matchInclusion = false;
            boolean supportResource = false;
            for (PathPattern pattern : inclusionPatterns) {
                if (!pattern.supportResource()) continue;
                supportResource = true;
                matchInclusion |= pattern.match(resource);
            }
            if (supportResource && !matchInclusion) {
                return true;
            }
        }
        return false;
    }

    private boolean isIgnoredByExclusions(Resource resource, PathPattern[] exclusionPatterns) {
        for (PathPattern pattern : exclusionPatterns) {
            if (!pattern.supportResource() || !pattern.match(resource)) continue;
            return true;
        }
        return false;
    }

    PathPattern[] sourceInclusions() {
        return PathPattern.create(this.exclusionSettings.sourceInclusions());
    }

    PathPattern[] testInclusions() {
        return PathPattern.create(this.exclusionSettings.testInclusions());
    }

    PathPattern[] sourceExclusions() {
        return PathPattern.create(this.exclusionSettings.sourceExclusions());
    }

    PathPattern[] testExclusions() {
        return PathPattern.create(this.exclusionSettings.testExclusions());
    }
}

