/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.phases;

import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchComponent;
import org.sonar.api.batch.BatchExtensionDictionnary;
import org.sonar.api.batch.PostJob;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.maven.DependsUponMavenPlugin;
import org.sonar.api.batch.maven.MavenPluginHandler;
import org.sonar.api.resources.Project;
import org.sonar.batch.local.DryRunExporter;
import org.sonar.batch.scan.filesystem.DefaultModuleFileSystem;
import org.sonar.batch.scan.maven.MavenPluginExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostJobsExecutor
implements BatchComponent {
    private static final Logger LOG = LoggerFactory.getLogger(PostJobsExecutor.class);
    private final BatchExtensionDictionnary selector;
    private final Project project;
    private final DefaultModuleFileSystem fs;
    private final MavenPluginExecutor mavenExecutor;
    private final DryRunExporter localModeExporter;

    public PostJobsExecutor(BatchExtensionDictionnary selector, Project project, DefaultModuleFileSystem fs, MavenPluginExecutor mavenExecutor, DryRunExporter localModeExporter) {
        this.selector = selector;
        this.project = project;
        this.fs = fs;
        this.mavenExecutor = mavenExecutor;
        this.localModeExporter = localModeExporter;
    }

    public void execute(SensorContext context) {
        Collection postJobs = this.selector.select(PostJob.class, this.project, true);
        this.execute(context, postJobs);
        this.exportLocalModeResults(context);
    }

    private void execute(SensorContext context, Collection<PostJob> postJobs) {
        this.logPostJobs(postJobs);
        for (PostJob postJob : postJobs) {
            LOG.info("Executing post-job {}", postJob.getClass());
            this.executeMavenPlugin(postJob);
            postJob.executeOn(this.project, context);
        }
    }

    private void logPostJobs(Collection<PostJob> postJobs) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Post-jobs : {}", (Object)StringUtils.join(postJobs, (String)" -> "));
        }
    }

    private void executeMavenPlugin(PostJob job) {
        MavenPluginHandler handler;
        if (job instanceof DependsUponMavenPlugin && (handler = ((DependsUponMavenPlugin)job).getMavenPluginHandler(this.project)) != null) {
            this.mavenExecutor.execute(this.project, this.fs, handler);
        }
    }

    private void exportLocalModeResults(SensorContext context) {
        this.localModeExporter.execute(context);
    }
}

