/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.components;

import java.util.Date;
import java.util.List;
import org.apache.commons.lang.time.DateUtils;
import org.sonar.api.BatchExtension;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.model.Snapshot;
import org.sonar.batch.components.PastSnapshot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PastSnapshotFinderByDays
implements BatchExtension {
    private DatabaseSession session;

    public PastSnapshotFinderByDays(DatabaseSession session) {
        this.session = session;
    }

    PastSnapshot findFromDays(Snapshot projectSnapshot, int days) {
        Date targetDate = DateUtils.addDays((Date)projectSnapshot.getCreatedAt(), (int)(-days));
        String hql = "from " + Snapshot.class.getSimpleName() + " where resourceId=:resourceId AND status=:status AND createdAt<:date AND qualifier<>:lib order by createdAt asc";
        List snapshots = this.session.createQuery(hql).setParameter("date", (Object)projectSnapshot.getCreatedAt()).setParameter("resourceId", (Object)projectSnapshot.getResourceId()).setParameter("status", (Object)"P").setParameter("lib", (Object)"LIB").getResultList();
        Snapshot snapshot = PastSnapshotFinderByDays.getNearestToTarget(snapshots, targetDate);
        return new PastSnapshot("days", targetDate, snapshot).setModeParameter(String.valueOf(days));
    }

    static Snapshot getNearestToTarget(List<Snapshot> snapshots, Date currentDate, int distanceInDays) {
        Date targetDate = DateUtils.addDays((Date)currentDate, (int)(-distanceInDays));
        return PastSnapshotFinderByDays.getNearestToTarget(snapshots, targetDate);
    }

    static Snapshot getNearestToTarget(List<Snapshot> snapshots, Date targetDate) {
        long bestDistance = Long.MAX_VALUE;
        Snapshot nearest = null;
        for (Snapshot snapshot : snapshots) {
            long distance = PastSnapshotFinderByDays.distance(snapshot.getCreatedAt(), targetDate);
            if (distance > bestDistance) continue;
            bestDistance = distance;
            nearest = snapshot;
        }
        return nearest;
    }

    static long distance(Date d1, Date d2) {
        return Math.abs(d1.getTime() - d2.getTime());
    }
}

