/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Properties;
import org.codehaus.plexus.util.StringUtils;
import org.sonar.api.batch.bootstrap.ProjectReactor;
import org.sonar.batch.bootstrap.GlobalBatchProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BootstrapSettings {
    private Map<String, String> properties;

    public BootstrapSettings(GlobalBatchProperties globalProperties) {
        this.init(null, globalProperties);
    }

    public BootstrapSettings(ProjectReactor reactor, GlobalBatchProperties globalProperties) {
        this.init(reactor, globalProperties);
    }

    private void init(ProjectReactor reactor, GlobalBatchProperties globalProperties) {
        this.properties = Maps.newHashMap();
        this.properties.putAll(globalProperties.getProperties());
        if (reactor != null) {
            this.addProperties(reactor.getRoot().getProperties());
        }
        this.properties.putAll(System.getenv());
        this.addProperties(System.getProperties());
    }

    private void addProperties(Properties p) {
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            if (entry.getValue() == null) continue;
            this.properties.put(entry.getKey().toString(), entry.getValue().toString());
        }
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public String getProperty(String key, String defaultValue) {
        return StringUtils.defaultString((Object)this.properties.get(key), (String)defaultValue);
    }
}

