/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.keytool;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.utils.cli.Commandline;
import org.codehaus.mojo.keytool.AbstractKeyToolRequestWithKeyStoreAndAliasParametersMojo;
import org.codehaus.mojo.keytool.requests.KeyToolImportCertificateRequest;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="importCertificate", requiresProject=true)
public class ImportCertificateMojo
extends AbstractKeyToolRequestWithKeyStoreAndAliasParametersMojo<KeyToolImportCertificateRequest> {
    @Parameter
    private String keypass;
    @Parameter
    private String file;
    @Parameter
    private boolean noprompt;
    @Parameter
    private boolean trustcacerts;
    @Parameter
    private boolean skipIfExist;

    public ImportCertificateMojo() {
        super(KeyToolImportCertificateRequest.class);
    }

    @Override
    public void execute() throws MojoExecutionException {
        File keystoreFile;
        boolean keystoreFileExists;
        if (this.skipIfExist && (keystoreFileExists = (keystoreFile = this.getKeystoreFile()).exists())) {
            this.getLog().info((CharSequence)("Skip execution, keystore already exists at " + keystoreFile));
            this.setSkip(true);
        }
        super.execute();
    }

    @Override
    protected KeyToolImportCertificateRequest createKeytoolRequest() {
        KeyToolImportCertificateRequest request = (KeyToolImportCertificateRequest)super.createKeytoolRequest();
        request.setKeypass(this.keypass);
        request.setFile(this.file);
        request.setNoprompt(this.noprompt);
        request.setTrustcacerts(this.trustcacerts);
        return request;
    }

    @Override
    protected String getCommandlineInfo(Commandline commandLine) {
        String commandLineInfo = super.getCommandlineInfo(commandLine);
        commandLineInfo = StringUtils.replace((String)commandLineInfo, (String)this.keypass, (String)"'*****'");
        return commandLineInfo;
    }
}

