/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.cobertura.configuration;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.mojo.cobertura.configuration.MaxHeapSizeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigInstrumentation {
    private File basedir;
    private List<String> excludes;
    private List<String> ignores;
    private List<String> includes = new ArrayList<String>();
    private String maxmem;

    public ConfigInstrumentation() {
        this.excludes = new ArrayList<String>();
        this.ignores = new ArrayList<String>();
        this.basedir = new File(System.getProperty("user.dir"));
        this.maxmem = MaxHeapSizeUtil.getInstance().envHasMavenMaxMemSetting() ? MaxHeapSizeUtil.getInstance().getMavenMaxMemSetting() : "64m";
    }

    public void addExclude(String exclude) {
        this.excludes.add(exclude);
    }

    public void addIgnore(String ignore) {
        this.ignores.add(ignore);
    }

    public void addInclude(String include) {
        this.includes.add(include);
    }

    public File getBasedir() {
        return this.basedir;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public List<String> getIgnores() {
        return this.ignores;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public String getMaxmem() {
        return this.maxmem;
    }

    public void setMaxmem(String maxmem) {
        this.maxmem = maxmem;
    }

    public String toString() {
        Iterator<String> it;
        StringBuffer sb = new StringBuffer();
        sb.append("<ConfigInstrumentation");
        sb.append(" basedir=\"");
        if (this.basedir != null) {
            sb.append(this.basedir.getAbsolutePath());
        }
        sb.append("\"");
        if (!this.includes.isEmpty()) {
            sb.append(" includes=\"");
            it = this.includes.iterator();
            while (it.hasNext()) {
                String include = it.next();
                sb.append(include);
                if (!it.hasNext()) continue;
                sb.append(" ");
            }
            sb.append("\"");
        }
        if (!this.excludes.isEmpty()) {
            sb.append(" excludes=\"");
            it = this.excludes.iterator();
            while (it.hasNext()) {
                String exclude = it.next();
                sb.append(exclude);
                if (!it.hasNext()) continue;
                sb.append(" ");
            }
            sb.append("\"");
        }
        if (!this.ignores.isEmpty()) {
            sb.append(" ignores=\"");
            it = this.ignores.iterator();
            while (it.hasNext()) {
                String ignore = it.next();
                sb.append(ignore);
                if (!it.hasNext()) continue;
                sb.append(" ");
            }
            sb.append("\"");
        }
        if (0 != this.getMaxmem().length()) {
            sb.append(" maxmem=\"");
            sb.append(this.getMaxmem());
            sb.append("\"");
        }
        return sb.append(" />").toString();
    }
}

