/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.ant;

import java.io.File;
import java.lang.reflect.Method;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.compilers.CompilerAdapter;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.SourceFileScanner;
import org.codehaus.groovy.eclipse.ant.GroovyFileNameMapper;
import org.eclipse.jdt.core.JDTCompilerAdapter;

public class GroovyCompilerAdapter
extends JDTCompilerAdapter
implements CompilerAdapter {
    public void setJavac(Javac javac) {
        super.setJavac(javac);
        File[] groovyFiles = this.getGroovyFiles(javac);
        if (groovyFiles.length > 0) {
            int i = 0;
            while (i < groovyFiles.length) {
                javac.log("Compiling " + groovyFiles.length + " groovy source file" + (groovyFiles.length == 1 ? "" : "s") + (this.destDir != null ? " to " + this.destDir : ""));
                String filename = groovyFiles[i].getAbsolutePath();
                javac.log(filename);
                ++i;
            }
            File[] newCompileList = new File[groovyFiles.length + this.compileList.length];
            System.arraycopy(this.compileList, 0, newCompileList, 0, this.compileList.length);
            System.arraycopy(groovyFiles, 0, newCompileList, this.compileList.length, groovyFiles.length);
            this.compileList = newCompileList;
        }
    }

    protected File[] getGroovyFiles(Javac javac) {
        String[] list = javac.getSrcdir().list();
        File destDir = javac.getDestdir();
        File[] sourceFiles = new File[]{};
        int i = 0;
        while (i < list.length) {
            GroovyFileNameMapper m;
            File srcDir = javac.getProject().resolveFile(list[i]);
            if (!srcDir.exists()) {
                throw new BuildException("srcdir \"" + srcDir.getPath() + "\" does not exist!", javac.getLocation());
            }
            SourceFileScanner sfs = new SourceFileScanner((Task)javac);
            DirectoryScanner ds = this.getDirectoryScanner(srcDir, javac);
            String[] files = ds.getIncludedFiles();
            File[] moreFiles = sfs.restrictAsFiles(files, srcDir, destDir, (FileNameMapper)(m = new GroovyFileNameMapper()));
            if (moreFiles != null) {
                File[] origFiles = sourceFiles;
                sourceFiles = new File[origFiles.length + moreFiles.length];
                System.arraycopy(origFiles, 0, sourceFiles, 0, origFiles.length);
                System.arraycopy(moreFiles, 0, sourceFiles, origFiles.length, moreFiles.length);
            }
            ++i;
        }
        return sourceFiles;
    }

    private DirectoryScanner getDirectoryScanner(File srcDir, Javac javac) {
        try {
            Method getDirectoryScannerMethod = MatchingTask.class.getDeclaredMethod("getDirectoryScanner", File.class);
            getDirectoryScannerMethod.setAccessible(true);
            return (DirectoryScanner)getDirectoryScannerMethod.invoke((Object)javac, srcDir);
        }
        catch (Exception e) {
            throw new BuildException("Problem finding directory scanner for srcdir \"" + srcDir.getPath() + "\"", (Throwable)e);
        }
    }
}

