/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.groovy.search.ITypeLookup;
import org.eclipse.jdt.internal.core.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeLookupRegistry {
    private static final String APPLIES_TO = "appliesTo";
    private static final String NATURE = "projectNature";
    private static final String LOOKUP = "lookup";
    private static final String TYPE_LOOKUP_EXTENSION = "org.eclipse.jdt.groovy.core.typeLookup";
    private static final TypeLookupRegistry DEFAULT = new TypeLookupRegistry();
    private Map<String, List<IConfigurationElement>> natureLookupMap = new HashMap<String, List<IConfigurationElement>>();

    static TypeLookupRegistry getRegistry() {
        return DEFAULT;
    }

    List<ITypeLookup> getLookupsFor(IProject project) throws CoreException {
        if (!project.exists()) {
            return new ArrayList<ITypeLookup>(3);
        }
        String[] natures = project.getDescription().getNatureIds();
        ArrayList<ITypeLookup> lookups = new ArrayList<ITypeLookup>();
        String[] stringArray = natures;
        int n = natures.length;
        int n2 = 0;
        while (n2 < n) {
            String nature = stringArray[n2];
            List<IConfigurationElement> configs = this.natureLookupMap.get(nature);
            if (configs != null) {
                for (IConfigurationElement config : configs) {
                    try {
                        lookups.add((ITypeLookup)config.createExecutableExtension(LOOKUP));
                    }
                    catch (CoreException e) {
                        Util.log(e, "Problem creating lookup for type " + config.getAttribute(LOOKUP));
                    }
                }
            }
            ++n2;
        }
        return lookups;
    }

    private TypeLookupRegistry() {
        this.initialize();
    }

    private void initialize() {
        IExtension[] exts;
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint(TYPE_LOOKUP_EXTENSION);
        IExtension[] iExtensionArray = exts = extPoint.getExtensions();
        int n = exts.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configs;
            IExtension ext = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configs = ext.getConfigurationElements();
            int n3 = configs.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement config = iConfigurationElementArray[n4];
                this.createLookup(config);
                ++n4;
            }
            ++n2;
        }
    }

    private void createLookup(IConfigurationElement config) {
        try {
            if (config.getName().equals(LOOKUP)) {
                if (config.getAttribute(LOOKUP) != null) {
                    IConfigurationElement[] appliesTos;
                    IConfigurationElement[] iConfigurationElementArray = appliesTos = config.getChildren(APPLIES_TO);
                    int n = appliesTos.length;
                    int n2 = 0;
                    while (n2 < n) {
                        List<Object> elts;
                        IConfigurationElement appliesTo = iConfigurationElementArray[n2];
                        String nature = appliesTo.getAttribute(NATURE);
                        if (this.natureLookupMap.containsKey(nature)) {
                            elts = this.natureLookupMap.get(nature);
                        } else {
                            elts = new ArrayList(3);
                            this.natureLookupMap.put(nature, elts);
                        }
                        elts.add(config);
                        ++n2;
                    }
                } else {
                    Util.log(new RuntimeException(), "Type lookup registry extension found with no type lookup class.");
                }
            }
        }
        catch (Exception e) {
            Util.log(e, "Problem registering type lookups");
        }
    }
}

