/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import java.util.List;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.eclipse.jdt.groovy.search.VariableScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum AccessorSupport {
    GETTER("get"),
    SETTER("set"),
    ISSER("is"),
    NONE("");

    private final String prefix;

    private AccessorSupport(String prefix) {
        this.prefix = prefix;
    }

    public boolean isAccessor() {
        return this != NONE;
    }

    public boolean isAccessorKind(MethodNode node, boolean isCategory) {
        int args = isCategory ? 1 : 0;
        ClassNode returnType = node.getReturnType();
        switch (this) {
            case GETTER: {
                return (node.getParameters() == null || node.getParameters().length == args) && !returnType.equals(VariableScope.VOID_CLASS_NODE);
            }
            case ISSER: {
                return !(isCategory || node.getParameters() != null && node.getParameters().length != args || !returnType.equals(VariableScope.OBJECT_CLASS_NODE) && !returnType.equals(VariableScope.BOOLEAN_CLASS_NODE) && !returnType.equals(ClassHelper.boolean_TYPE));
            }
            case SETTER: {
                return node.getParameters() != null && node.getParameters().length == args + 1 && (returnType.equals(VariableScope.VOID_CLASS_NODE) || returnType.equals(VariableScope.OBJECT_CLASS_NODE));
            }
        }
        return false;
    }

    public String createAccessorName(String name) {
        if (!name.startsWith(AccessorSupport.GETTER.prefix) && !name.startsWith(AccessorSupport.SETTER.prefix) && name.length() > 0) {
            return String.valueOf(this.prefix) + Character.toUpperCase(name.charAt(0)) + (name.length() > 1 ? name.substring(1) : "");
        }
        return null;
    }

    public static AccessorSupport findAccessorKind(MethodNode node, boolean isCategory) {
        AccessorSupport accessor = AccessorSupport.create(node.getName(), isCategory);
        return accessor.isAccessorKind(node, isCategory) ? accessor : NONE;
    }

    public static MethodNode findAccessorMethodForPropertyName(String name, ClassNode declaringType, boolean isCategory) {
        MethodNode maybeMethod;
        MethodNode maybeMethod2;
        MethodNode maybeMethod3;
        if (name.length() <= 0) {
            return null;
        }
        String suffix = String.valueOf(Character.toUpperCase(name.charAt(0))) + (name.length() > 1 ? name.substring(1) : "");
        String getterName = "get" + suffix;
        List<MethodNode> methods = declaringType.getMethods(getterName);
        if (!methods.isEmpty() && AccessorSupport.findAccessorKind(maybeMethod3 = methods.get(0), isCategory) == GETTER) {
            return maybeMethod3;
        }
        String setterName = "set" + suffix;
        methods = declaringType.getMethods(setterName);
        if (!methods.isEmpty() && AccessorSupport.findAccessorKind(maybeMethod2 = methods.get(0), isCategory) == SETTER) {
            return maybeMethod2;
        }
        String isserName = "is" + suffix;
        methods = declaringType.getMethods(isserName);
        if (!methods.isEmpty() && AccessorSupport.findAccessorKind(maybeMethod = methods.get(0), isCategory) == ISSER) {
            return maybeMethod;
        }
        return null;
    }

    public static boolean isGetter(MethodNode node) {
        return node.getReturnType() != VariableScope.VOID_CLASS_NODE && node.getParameters().length == 0 && (node.getName().startsWith("get") && node.getName().length() > 3 || node.getName().startsWith("is") && node.getName().length() > 2);
    }

    public static AccessorSupport create(String methodName, boolean isCategory) {
        AccessorSupport accessor = NONE;
        if (!isCategory && methodName.length() > 2 && methodName.startsWith("is") && Character.isUpperCase(methodName.charAt(2))) {
            accessor = ISSER;
        }
        if (!accessor.isAccessor() && methodName.length() > 3 && (methodName.startsWith("get") || methodName.startsWith("set")) && Character.isUpperCase(methodName.charAt(3))) {
            accessor = methodName.charAt(0) == 'g' ? GETTER : SETTER;
        }
        return accessor;
    }
}

