/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.finder.impl;

import com.sun.xacml.AbstractPolicy;
import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.MatchResult;
import com.sun.xacml.Policy;
import com.sun.xacml.PolicySet;
import com.sun.xacml.ctx.Status;
import com.sun.xacml.finder.PolicyFinder;
import com.sun.xacml.finder.PolicyFinderModule;
import com.sun.xacml.finder.PolicyFinderResult;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class FilePolicyModule
extends PolicyFinderModule
implements ErrorHandler {
    public static final String POLICY_SCHEMA_PROPERTY = "com.sun.xacml.PolicySchema";
    public static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private PolicyFinder finder;
    private File schemaFile;
    private Set fileNames = new HashSet();
    private Set policies = new HashSet();
    private static final Logger logger = Logger.getLogger((class$com$sun$xacml$finder$impl$FilePolicyModule == null ? (class$com$sun$xacml$finder$impl$FilePolicyModule = FilePolicyModule.class$("com.sun.xacml.finder.impl.FilePolicyModule")) : class$com$sun$xacml$finder$impl$FilePolicyModule).getName());
    static /* synthetic */ Class class$com$sun$xacml$finder$impl$FilePolicyModule;

    public FilePolicyModule() {
        String schemaName = System.getProperty(POLICY_SCHEMA_PROPERTY);
        this.schemaFile = schemaName == null ? null : new File(schemaName);
    }

    public FilePolicyModule(File schemaFile) {
        this.schemaFile = schemaFile;
    }

    public FilePolicyModule(List fileNames) {
        this();
        if (fileNames != null) {
            this.fileNames.addAll(fileNames);
        }
    }

    public boolean isRequestSupported() {
        return true;
    }

    public void init(PolicyFinder finder) {
        this.finder = finder;
        Iterator it = this.fileNames.iterator();
        while (it.hasNext()) {
            String fname = (String)it.next();
            AbstractPolicy policy = FilePolicyModule.loadPolicy(fname, finder, this.schemaFile, this);
            if (policy == null) continue;
            this.policies.add(policy);
        }
    }

    public boolean addPolicy(String filename) {
        return this.fileNames.add(filename);
    }

    public static AbstractPolicy loadPolicy(String filename, PolicyFinder finder) {
        return FilePolicyModule.loadPolicy(filename, finder, null, null);
    }

    public static AbstractPolicy loadPolicy(String filename, PolicyFinder finder, File schemaFile, ErrorHandler handler) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringComments(true);
            DocumentBuilder db = null;
            factory.setNamespaceAware(true);
            if (schemaFile == null) {
                factory.setValidating(false);
                db = factory.newDocumentBuilder();
            } else {
                factory.setValidating(true);
                factory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
                factory.setAttribute(JAXP_SCHEMA_SOURCE, schemaFile);
                db = factory.newDocumentBuilder();
                db.setErrorHandler(handler);
            }
            Document doc = db.parse(new FileInputStream(filename));
            Element root = doc.getDocumentElement();
            String name = root.getTagName();
            if (name.equals("Policy")) {
                return Policy.getInstance(root);
            }
            if (name.equals("PolicySet")) {
                return PolicySet.getInstance(root, finder);
            }
            throw new Exception("Unknown root document type: " + name);
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "Error reading policy from file " + filename, e);
            }
            return null;
        }
    }

    public PolicyFinderResult findPolicy(EvaluationCtx context) {
        AbstractPolicy selectedPolicy = null;
        Iterator it = this.policies.iterator();
        while (it.hasNext()) {
            AbstractPolicy policy = (AbstractPolicy)it.next();
            MatchResult match = policy.match(context);
            int result = match.getResult();
            if (result == 2) {
                return new PolicyFinderResult(match.getStatus());
            }
            if (result != 0) continue;
            if (selectedPolicy != null) {
                ArrayList<String> code = new ArrayList<String>();
                code.add("urn:oasis:names:tc:xacml:1.0:status:processing-error");
                Status status = new Status(code, "too many applicable top-level policies");
                return new PolicyFinderResult(status);
            }
            selectedPolicy = policy;
        }
        if (selectedPolicy != null) {
            return new PolicyFinderResult(selectedPolicy);
        }
        return new PolicyFinderResult();
    }

    public void warning(SAXParseException exception) throws SAXException {
        if (logger.isLoggable(Level.WARNING)) {
            logger.warning("Warning on line " + exception.getLineNumber() + ": " + exception.getMessage());
        }
    }

    public void error(SAXParseException exception) throws SAXException {
        if (logger.isLoggable(Level.WARNING)) {
            logger.warning("Error on line " + exception.getLineNumber() + ": " + exception.getMessage() + " ... " + "Policy will not be available");
        }
        throw new SAXException("error parsing policy");
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        if (logger.isLoggable(Level.WARNING)) {
            logger.warning("Fatal error on line " + exception.getLineNumber() + ": " + exception.getMessage() + " ... " + "Policy will not be available");
        }
        throw new SAXException("fatal error parsing policy");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

