/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.finder.impl;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.BagAttribute;
import com.sun.xacml.attr.DateAttribute;
import com.sun.xacml.attr.DateTimeAttribute;
import com.sun.xacml.attr.TimeAttribute;
import com.sun.xacml.cond.EvaluationResult;
import com.sun.xacml.ctx.Status;
import com.sun.xacml.finder.AttributeFinderModule;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class CurrentEnvModule
extends AttributeFinderModule {
    public static final String ENVIRONMENT_CURRENT_TIME = "urn:oasis:names:tc:xacml:1.0:environment:current-time";
    public static final String ENVIRONMENT_CURRENT_DATE = "urn:oasis:names:tc:xacml:1.0:environment:current-date";
    public static final String ENVIRONMENT_CURRENT_DATETIME = "urn:oasis:names:tc:xacml:1.0:environment:current-dateTime";

    public boolean isDesignatorSupported() {
        return true;
    }

    public Set getSupportedDesignatorTypes() {
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(new Integer(3));
        return set;
    }

    public EvaluationResult findAttribute(URI attributeType, URI attributeId, URI issuer, URI subjectCategory, EvaluationCtx context, int designatorType) {
        if (designatorType != 3) {
            return new EvaluationResult(BagAttribute.createEmptyBag(attributeType));
        }
        String attrName = attributeId.toString();
        if (attrName.equals(ENVIRONMENT_CURRENT_TIME)) {
            return this.handleTime(attributeType, issuer, context);
        }
        if (attrName.equals(ENVIRONMENT_CURRENT_DATE)) {
            return this.handleDate(attributeType, issuer, context);
        }
        if (attrName.equals(ENVIRONMENT_CURRENT_DATETIME)) {
            return this.handleDateTime(attributeType, issuer, context);
        }
        return new EvaluationResult(BagAttribute.createEmptyBag(attributeType));
    }

    private EvaluationResult handleTime(URI type, URI issuer, EvaluationCtx context) {
        if (!type.toString().equals("http://www.w3.org/2001/XMLSchema#time")) {
            return new EvaluationResult(BagAttribute.createEmptyBag(type));
        }
        TimeAttribute attr = context.getCurrentTime();
        if (attr == null) {
            attr = new TimeAttribute();
            context.setCurrentTime(attr);
        }
        return this.makeBag(attr);
    }

    private EvaluationResult handleDate(URI type, URI issuer, EvaluationCtx context) {
        if (!type.toString().equals("http://www.w3.org/2001/XMLSchema#date")) {
            return new EvaluationResult(BagAttribute.createEmptyBag(type));
        }
        DateAttribute attr = context.getCurrentDate();
        if (attr == null) {
            attr = new DateAttribute();
            context.setCurrentDate(attr);
        }
        return this.makeBag(attr);
    }

    private EvaluationResult handleDateTime(URI type, URI issuer, EvaluationCtx context) {
        if (!type.toString().equals("http://www.w3.org/2001/XMLSchema#dateTime")) {
            return new EvaluationResult(BagAttribute.createEmptyBag(type));
        }
        DateTimeAttribute attr = context.getCurrentDateTime();
        if (attr == null) {
            attr = new DateTimeAttribute();
            context.setCurrentDateTime(attr);
        }
        return this.makeBag(attr);
    }

    private EvaluationResult makeProcessingError(String message) {
        ArrayList<String> code = new ArrayList<String>();
        code.add("urn:oasis:names:tc:xacml:1.0:status:processing-error");
        return new EvaluationResult(new Status(code, message));
    }

    private EvaluationResult makeBag(AttributeValue attribute) {
        HashSet<AttributeValue> set = new HashSet<AttributeValue>();
        set.add(attribute);
        BagAttribute bag = new BagAttribute(attribute.getType(), set);
        return new EvaluationResult(bag);
    }
}

